/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.console.synchronisation;

import java.util.Set;
import net.grinder.communication.CommunicationException;
import net.grinder.synchronisation.AbstractBarrierGroups;
import net.grinder.synchronisation.BarrierGroup;
import net.grinder.synchronisation.BarrierGroups;
import net.grinder.synchronisation.messages.BarrierIdentity;

final class ProcessBarrierGroups
extends AbstractBarrierGroups {
    private final BarrierGroups m_delegate;

    public ProcessBarrierGroups(BarrierGroups consoleBarrierGroups) {
        this.m_delegate = consoleBarrierGroups;
    }

    @Override
    protected AbstractBarrierGroups.BarrierGroupImplementation createBarrierGroup(String name) {
        final BarrierGroup delegateGroup = this.m_delegate.getGroup(name);
        return new AbstractBarrierGroups.BarrierGroupImplementation(name){
            {
                super(x0);
                delegateGroup.addListener(new BarrierGroup.Listener(){

                    @Override
                    public void awaken(Set<BarrierIdentity> waiters) {
                        this.clearWaiters(waiters);
                    }
                });
            }

            @Override
            public void addBarrier() throws CommunicationException {
                super.addBarrier();
                delegateGroup.addBarrier();
            }

            @Override
            public void removeBarriers(long n) throws CommunicationException {
                super.removeBarriers(n);
                delegateGroup.removeBarriers(n);
            }

            @Override
            public void addWaiter(BarrierIdentity barrierIdentity) throws CommunicationException {
                super.addWaiter(barrierIdentity);
                delegateGroup.addWaiter(barrierIdentity);
            }

            @Override
            public void cancelWaiter(BarrierIdentity barrierIdentity) throws CommunicationException {
                super.cancelWaiter(barrierIdentity);
                delegateGroup.cancelWaiter(barrierIdentity);
            }
        };
    }
}

