/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.console.model;

import java.util.Collection;
import java.util.EventListener;
import java.util.Set;
import net.grinder.common.Test;
import net.grinder.console.model.ModelTestIndex;
import net.grinder.console.model.SampleListener;
import net.grinder.statistics.StatisticExpression;
import net.grinder.statistics.StatisticsSet;
import net.grinder.statistics.TestStatisticsMap;

public interface SampleModel {
    public void reset();

    public void zeroStatistics();

    public void start();

    public void stop();

    public State getState();

    public StatisticExpression getTPSExpression();

    public StatisticExpression getPeakTPSExpression();

    public StatisticsSet getTotalCumulativeStatistics();

    public StatisticsSet getTotalLatestStatistics();

    public void addModelListener(Listener var1);

    public void addTotalSampleListener(SampleListener var1);

    public void addSampleListener(Test var1, SampleListener var2);

    public void registerTests(Collection<Test> var1);

    public void addTestReport(TestStatisticsMap var1);

    public static abstract class AbstractListener
    implements Listener {
        @Override
        public void newSample() {
        }

        @Override
        public void newTests(Set<Test> newTests, ModelTestIndex modelTestIndex) {
        }

        @Override
        public void resetTests() {
        }

        @Override
        public void stateChanged() {
        }
    }

    public static interface Listener
    extends EventListener {
        public void stateChanged();

        public void newSample();

        public void newTests(Set<Test> var1, ModelTestIndex var2);

        public void resetTests();
    }

    public static interface State {
        public Value getValue();

        public String getDescription();

        public long getSampleCount();

        public static enum Value {
            Stopped,
            WaitingForFirstReport,
            IgnoringInitialSamples,
            Recording;

        }
    }
}

