/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.console.editor;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.EventListener;
import net.grinder.common.Closer;
import net.grinder.common.UncheckedInterruptedException;
import net.grinder.console.common.DisplayMessageConsoleException;
import net.grinder.console.common.Resources;
import net.grinder.console.editor.Buffer;
import net.grinder.console.editor.EditorException;
import net.grinder.console.editor.TextSource;
import net.grinder.util.ListenerSupport;

final class BufferImplementation
implements Buffer {
    private final Resources m_resources;
    private final TextSource m_textSource;
    private final ListenerSupport<Listener> m_listeners = new ListenerSupport();
    private String m_name;
    private File m_file;
    private long m_lastModified = -1L;

    BufferImplementation(Resources resources, TextSource textSource, String name) {
        this.m_resources = resources;
        this.m_textSource = textSource;
        this.m_file = null;
        this.m_name = name;
    }

    BufferImplementation(Resources resources, TextSource textSource, File file) {
        this.m_resources = resources;
        this.m_textSource = textSource;
        this.setFile(file);
    }

    @Override
    public TextSource getTextSource() {
        return this.m_textSource;
    }

    @Override
    public void load() throws DisplayMessageConsoleException, EditorException {
        if (this.m_file == null) {
            throw new EditorException("Can't load a buffer that has no associated file");
        }
        StringWriter stringWriter = new StringWriter();
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new FileReader(this.m_file));
            while ((line = reader.readLine()) != null) {
                stringWriter.write(line);
                stringWriter.write(10);
            }
        }
        catch (IOException e) {
            try {
                UncheckedInterruptedException.ioException(e);
                throw new DisplayMessageConsoleException(this.m_resources, "fileReadError.text", new Object[]{this.m_file, ".\n(" + BufferImplementation.extractReasonFromIOException(e) + ")"}, e);
            }
            catch (Throwable throwable) {
                Closer.close(reader);
                throw throwable;
            }
        }
        Closer.close(reader);
        this.m_textSource.setText(stringWriter.toString());
        this.m_lastModified = this.m_file.lastModified();
    }

    @Override
    public void save() throws DisplayMessageConsoleException, EditorException {
        if (this.m_file == null) {
            throw new EditorException("Can't save a buffer that has no associated file");
        }
        this.save(this.m_file);
    }

    @Override
    public void save(File file) throws DisplayMessageConsoleException {
        final File oldFile = this.getFile();
        FileWriter fileWriter = null;
        try {
            String text = this.m_textSource.getText();
            String[] lines = text.split("\n", -1);
            fileWriter = new FileWriter(file);
            PrintWriter printWriter = new PrintWriter(fileWriter);
            for (int i = 0; i < lines.length; ++i) {
                printWriter.println(lines[i]);
            }
            this.setFile(file);
            printWriter.close();
            this.m_lastModified = this.m_file.lastModified();
            this.m_listeners.apply(new ListenerSupport.Informer<Listener>(){

                @Override
                public void inform(Listener l) {
                    l.bufferSaved(BufferImplementation.this, oldFile);
                }
            });
        }
        catch (IOException e) {
            try {
                UncheckedInterruptedException.ioException(e);
                throw new DisplayMessageConsoleException(this.m_resources, "fileWriteError.text", new Object[]{this.m_file, "./n(" + BufferImplementation.extractReasonFromIOException(e) + ")"}, e);
            }
            catch (Throwable throwable) {
                Closer.close(fileWriter);
                throw throwable;
            }
        }
        Closer.close(fileWriter);
    }

    @Override
    public boolean isDirty() {
        return this.m_textSource.isDirty();
    }

    private void setFile(File file) {
        this.m_file = file;
        this.m_name = file.getName();
    }

    @Override
    public File getFile() {
        return this.m_file;
    }

    @Override
    public boolean isUpToDate() {
        return this.m_file == null || this.m_lastModified == this.m_file.lastModified();
    }

    @Override
    public Buffer.Type getType() {
        String name;
        int lastDot;
        if (this.m_file != null && (lastDot = (name = this.m_file.getName()).lastIndexOf(46)) >= 0) {
            String extension = name.substring(lastDot + 1);
            return Buffer.Type.forExtension(extension);
        }
        return Buffer.Type.TEXT_BUFFER;
    }

    @Override
    public String getDisplayName() {
        return this.m_name;
    }

    @Override
    public String toString() {
        return "<Buffer " + this.hashCode() + " '" + this.getDisplayName() + "'>";
    }

    @Override
    public void addListener(Listener listener) {
        this.m_listeners.add(listener);
    }

    static String extractReasonFromIOException(IOException e) {
        if (e instanceof FileNotFoundException) {
            String message = e.getMessage();
            int firstParenthesis = message.indexOf(40);
            int secondsParenthesis = message.indexOf(41, firstParenthesis);
            if (firstParenthesis >= 0 && secondsParenthesis > firstParenthesis + 1) {
                return message.substring(firstParenthesis + 1, secondsParenthesis);
            }
        }
        return "";
    }

    public static interface Listener
    extends EventListener {
        public void bufferSaved(Buffer var1, File var2);
    }
}

