/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.console.communication;

import java.io.File;
import java.util.Map;
import java.util.Timer;
import net.grinder.common.GrinderProperties;
import net.grinder.common.processidentity.AgentIdentity;
import net.grinder.communication.MessageDispatchRegistry;
import net.grinder.console.common.ConsoleException;
import net.grinder.console.common.DisplayMessageConsoleException;
import net.grinder.console.common.Resources;
import net.grinder.console.communication.ConsoleCommunication;
import net.grinder.console.communication.ProcessControl;
import net.grinder.console.communication.ProcessStatusImplementation;
import net.grinder.messages.agent.ResetGrinderMessage;
import net.grinder.messages.agent.StartGrinderMessage;
import net.grinder.messages.agent.StopGrinderMessage;
import net.grinder.messages.console.AgentAddress;
import net.grinder.messages.console.AgentProcessReportMessage;
import net.grinder.messages.console.WorkerProcessReportMessage;
import net.grinder.util.AllocateLowestNumber;
import net.grinder.util.AllocateLowestNumberImplementation;
import net.grinder.util.Directory;

public class ProcessControlImplementation
implements ProcessControl {
    private final ConsoleCommunication m_consoleCommunication;
    private final ProcessStatusImplementation m_processStatusSet;
    private final AllocateLowestNumber m_agentNumberMap = new AllocateLowestNumberImplementation();
    private final Resources m_resources;

    public ProcessControlImplementation(Timer timer, ConsoleCommunication consoleCommunication, Resources resources) {
        this.m_consoleCommunication = consoleCommunication;
        this.m_resources = resources;
        this.m_processStatusSet = new ProcessStatusImplementation(timer, this.m_agentNumberMap);
        MessageDispatchRegistry messageDispatchRegistry = consoleCommunication.getMessageDispatchRegistry();
        messageDispatchRegistry.set(AgentProcessReportMessage.class, new MessageDispatchRegistry.AbstractHandler<AgentProcessReportMessage>(){

            @Override
            public void handle(AgentProcessReportMessage message) {
                ProcessControlImplementation.this.m_processStatusSet.addAgentStatusReport(message);
            }
        });
        messageDispatchRegistry.set(WorkerProcessReportMessage.class, new MessageDispatchRegistry.AbstractHandler<WorkerProcessReportMessage>(){

            @Override
            public void handle(WorkerProcessReportMessage message) {
                ProcessControlImplementation.this.m_processStatusSet.addWorkerStatusReport(message);
            }
        });
    }

    @Override
    public void startWorkerProcesses(final GrinderProperties properties) {
        this.m_agentNumberMap.forEach(new AllocateLowestNumber.IteratorCallback(){

            @Override
            public void objectAndNumber(Object object, int number) {
                ProcessControlImplementation.this.m_consoleCommunication.sendToAddressedAgents(new AgentAddress((AgentIdentity)object), new StartGrinderMessage(properties, number));
            }
        });
    }

    @Override
    public void startWorkerProcessesWithDistributedFiles(Directory distributionDirectory, GrinderProperties properties) throws ConsoleException {
        File relativeFile;
        File configuredScript = properties.getFile("grinder.script", GrinderProperties.DEFAULT_SCRIPT);
        File resolvedScript = properties.resolveRelativeFile(configuredScript);
        File path = distributionDirectory.relativeFile(resolvedScript, true);
        if (path == null && !configuredScript.isAbsolute()) {
            throw new DisplayMessageConsoleException(this.m_resources, "scriptNotInDirectoryError.text");
        }
        GrinderProperties propertiesToSend = properties;
        File associatedFile = properties.getAssociatedFile();
        if (associatedFile != null && (relativeFile = distributionDirectory.relativeFile(associatedFile, true)) != null && !relativeFile.equals(associatedFile)) {
            propertiesToSend = new GrinderProperties();
            propertiesToSend.putAll((Map<?, ?>)properties);
            propertiesToSend.setAssociatedFile(relativeFile);
        }
        this.startWorkerProcesses(propertiesToSend);
    }

    @Override
    public void resetWorkerProcesses() {
        this.m_consoleCommunication.sendToAgents(new ResetGrinderMessage());
    }

    @Override
    public void stopAgentAndWorkerProcesses() {
        this.m_consoleCommunication.sendToAgents(new StopGrinderMessage());
    }

    @Override
    public void addProcessStatusListener(ProcessControl.Listener listener) {
        this.m_processStatusSet.addListener(listener);
    }

    @Override
    public int getNumberOfLiveAgents() {
        return this.m_processStatusSet.getNumberOfLiveAgents();
    }
}

