/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.console.communication;

import net.grinder.communication.Address;
import net.grinder.console.communication.ConsoleCommunication;
import net.grinder.console.communication.DistributionControl;
import net.grinder.messages.agent.CacheHighWaterMark;
import net.grinder.messages.agent.ClearCacheMessage;
import net.grinder.messages.agent.DistributeFileMessage;
import net.grinder.messages.agent.DistributionCacheCheckpointMessage;
import net.grinder.util.FileContents;

public class DistributionControlImplementation
implements DistributionControl {
    private final ConsoleCommunication m_consoleCommunication;

    public DistributionControlImplementation(ConsoleCommunication consoleCommunication) {
        this.m_consoleCommunication = consoleCommunication;
    }

    @Override
    public void clearFileCaches(Address address) {
        this.m_consoleCommunication.sendToAddressedAgents(address, new ClearCacheMessage());
    }

    @Override
    public void sendFile(Address address, FileContents fileContents) {
        this.m_consoleCommunication.sendToAddressedAgents(address, new DistributeFileMessage(fileContents));
    }

    @Override
    public void setHighWaterMark(Address address, CacheHighWaterMark highWaterMark) {
        this.m_consoleCommunication.sendToAddressedAgents(address, new DistributionCacheCheckpointMessage(highWaterMark));
    }
}

