/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.console.client;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.grinder.communication.ClientSender;
import net.grinder.communication.CommunicationException;
import net.grinder.communication.ConnectionType;
import net.grinder.communication.Connector;
import net.grinder.console.client.ConsoleConnection;
import net.grinder.console.client.ConsoleConnectionException;
import net.grinder.console.client.ConsoleConnectionImplementation;
import net.grinder.util.thread.ExecutorFactory;

public class ConsoleConnectionFactory {
    private final ScheduledExecutorService m_executor;

    public ConsoleConnectionFactory() {
        this(ExecutorFactory.getUtilityScheduledExecutor());
    }

    protected ConsoleConnectionFactory(ScheduledExecutorService executor) {
        this.m_executor = executor;
    }

    public ConsoleConnection connect(String host, int port) throws ConsoleConnectionException {
        try {
            final ClientSender sender = ClientSender.connect(new Connector(host, port, ConnectionType.CONSOLE_CLIENT), null);
            Runnable keepAlive = new Runnable(){

                @Override
                public void run() {
                    try {
                        sender.sendKeepAlive();
                    }
                    catch (CommunicationException e) {
                        throw new RuntimeException(e);
                    }
                }
            };
            this.m_executor.scheduleWithFixedDelay(keepAlive, 0L, 1L, TimeUnit.SECONDS);
            return new ConsoleConnectionImplementation(sender);
        }
        catch (CommunicationException e) {
            throw new ConsoleConnectionException("Failed to connect", e);
        }
    }
}

