/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.console;

import java.io.File;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Timer;
import net.grinder.common.GrinderException;
import net.grinder.communication.MessageDispatchRegistry;
import net.grinder.console.common.ErrorHandler;
import net.grinder.console.common.ErrorQueue;
import net.grinder.console.common.Resources;
import net.grinder.console.communication.ConsoleCommunication;
import net.grinder.console.communication.ConsoleCommunicationImplementation;
import net.grinder.console.communication.DistributionControlImplementation;
import net.grinder.console.communication.ProcessControlImplementation;
import net.grinder.console.communication.server.DispatchClientCommands;
import net.grinder.console.distribution.FileDistributionImplementation;
import net.grinder.console.distribution.WireFileDistribution;
import net.grinder.console.model.ConsoleProperties;
import net.grinder.console.model.SampleModel;
import net.grinder.console.model.SampleModelImplementation;
import net.grinder.console.model.SampleModelViews;
import net.grinder.console.model.SampleModelViewsImplementation;
import net.grinder.console.synchronisation.WireDistributedBarriers;
import net.grinder.console.textui.TextUI;
import net.grinder.messages.console.RegisterExpressionViewMessage;
import net.grinder.messages.console.RegisterTestsMessage;
import net.grinder.messages.console.ReportStatisticsMessage;
import net.grinder.statistics.StatisticsServicesImplementation;
import net.grinder.util.ClassLoaderUtilities;
import net.grinder.util.StandardTimeAuthority;
import org.picocontainer.ComponentFactory;
import org.picocontainer.ComponentMonitor;
import org.picocontainer.DefaultPicoContainer;
import org.picocontainer.LifecycleStrategy;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.Parameter;
import org.picocontainer.behaviors.Caching;
import org.picocontainer.lifecycle.CompositeLifecycleStrategy;
import org.picocontainer.lifecycle.JavaEE5LifecycleStrategy;
import org.picocontainer.lifecycle.StartableLifecycleStrategy;
import org.picocontainer.monitors.NullComponentMonitor;
import org.picocontainer.monitors.WriterComponentMonitor;
import org.picocontainer.parameters.ComponentParameter;
import org.picocontainer.parameters.ConstantParameter;
import org.slf4j.Logger;

public final class ConsoleFoundation {
    private static final String DYNAMIC_COMPONENT_RESOURCE_NAME = "META-INF/net.grinder.console";
    private final MutablePicoContainer m_container;
    private final Timer m_timer;

    public ConsoleFoundation(Resources resources, Logger logger, boolean headless) throws GrinderException {
        this(resources, logger, headless, new Timer(true), new ConsoleProperties(resources, new File(System.getProperty("user.home", System.getProperty("java.home")), ".grinder_console")));
    }

    public ConsoleFoundation(Resources resources, Logger logger, boolean headless, Timer timer, ConsoleProperties properties) throws GrinderException {
        this.m_timer = timer;
        NullComponentMonitor monitor = new NullComponentMonitor();
        CompositeLifecycleStrategy lifecycleStrategy = new CompositeLifecycleStrategy(new LifecycleStrategy[]{new StartableLifecycleStrategy((ComponentMonitor)monitor), new JavaEE5LifecycleStrategy((ComponentMonitor)new WriterComponentMonitor((Writer)new PrintWriter(System.err, true)))});
        this.m_container = new DefaultPicoContainer((ComponentFactory)new Caching(), (LifecycleStrategy)lifecycleStrategy, null);
        this.m_container.addComponent((Object)logger);
        this.m_container.addComponent((Object)resources);
        this.m_container.addComponent((Object)properties);
        this.m_container.addComponent((Object)timer);
        this.m_container.addComponent((Object)StatisticsServicesImplementation.getInstance());
        this.m_container.addComponent((Object)new StandardTimeAuthority());
        this.m_container.addComponent(SampleModelImplementation.class);
        this.m_container.addComponent(SampleModelViewsImplementation.class);
        this.m_container.addComponent(ConsoleCommunicationImplementation.class);
        this.m_container.addComponent(DistributionControlImplementation.class);
        this.m_container.addComponent(ProcessControlImplementation.class);
        this.m_container.addComponent(FileDistributionImplementation.class, FileDistributionImplementation.class, new Parameter[]{new ComponentParameter(DistributionControlImplementation.class), new ComponentParameter(ProcessControlImplementation.class), new ConstantParameter((Object)properties.getDistributionDirectory()), new ConstantParameter((Object)properties.getDistributionFileFilterPattern())});
        this.m_container.addComponent(DispatchClientCommands.class);
        this.m_container.addComponent(WireFileDistribution.class);
        this.m_container.addComponent(WireMessageDispatch.class);
        this.m_container.addComponent(ErrorQueue.class);
        this.m_container.addComponent(WireDistributedBarriers.class);
        ClassLoader classLoader = this.getClass().getClassLoader();
        Class uiClass = headless ? TextUI.class : null;
        for (Class<?> implementation : ClassLoaderUtilities.loadRegisteredImplementations(DYNAMIC_COMPONENT_RESOURCE_NAME, classLoader)) {
            if (uiClass == null && UI.class.isAssignableFrom(implementation)) {
                uiClass = implementation;
                continue;
            }
            this.m_container.addComponent(implementation);
        }
        if (uiClass == null) {
            uiClass = TextUI.class;
        }
        UI ui = (UI)this.m_container.addComponent(uiClass).getComponent(uiClass);
        ErrorQueue errorQueue = (ErrorQueue)this.m_container.getComponent(ErrorQueue.class);
        errorQueue.setErrorHandler(ui.getErrorHandler());
    }

    public void run() {
        this.m_container.start();
        this.m_container.getComponent(WireMessageDispatch.class);
        this.m_container.getComponent(WireFileDistribution.class);
        this.m_container.getComponent(WireDistributedBarriers.class);
        ConsoleCommunication communication = (ConsoleCommunication)this.m_container.getComponent(ConsoleCommunication.class);
        while (communication.processOneMessage()) {
        }
    }

    public void shutdown() {
        this.m_timer.cancel();
        this.m_container.dispose();
    }

    public static class WireMessageDispatch {
        public WireMessageDispatch(ConsoleCommunication communication, final SampleModel model, final SampleModelViews sampleModelViews, DispatchClientCommands dispatchClientCommands) {
            MessageDispatchRegistry messageDispatchRegistry = communication.getMessageDispatchRegistry();
            messageDispatchRegistry.set(RegisterTestsMessage.class, new MessageDispatchRegistry.AbstractHandler<RegisterTestsMessage>(){

                @Override
                public void handle(RegisterTestsMessage message) {
                    model.registerTests(message.getTests());
                }
            });
            messageDispatchRegistry.set(ReportStatisticsMessage.class, new MessageDispatchRegistry.AbstractHandler<ReportStatisticsMessage>(){

                @Override
                public void handle(ReportStatisticsMessage message) {
                    model.addTestReport(message.getStatisticsDelta());
                }
            });
            messageDispatchRegistry.set(RegisterExpressionViewMessage.class, new MessageDispatchRegistry.AbstractHandler<RegisterExpressionViewMessage>(){

                @Override
                public void handle(RegisterExpressionViewMessage message) {
                    sampleModelViews.registerStatisticExpression(message.getExpressionView());
                }
            });
            dispatchClientCommands.registerMessageHandlers(messageDispatchRegistry);
        }
    }

    public static interface UI {
        public ErrorHandler getErrorHandler();
    }
}

