/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.communication;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import net.grinder.common.Closer;
import net.grinder.communication.AbstractSender;
import net.grinder.communication.Message;

public class StreamSender
extends AbstractSender {
    private final OutputStream m_outputStream;
    private final Object m_streamLock;

    public StreamSender(OutputStream outputStream) {
        this(outputStream, outputStream);
    }

    private StreamSender(OutputStream outputStream, Object streamLock) {
        this.m_outputStream = new BufferedOutputStream(outputStream);
        this.m_streamLock = streamLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void writeMessage(Message message) throws IOException {
        Object object = this.m_streamLock;
        synchronized (object) {
            StreamSender.writeMessageToStream(message, this.m_outputStream);
        }
    }

    @Override
    public void shutdown() {
        super.shutdown();
        Closer.close(this.m_outputStream);
    }
}

