/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.communication;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.grinder.communication.CommunicationException;
import net.grinder.communication.Message;
import net.grinder.communication.MessageDispatchRegistry;
import net.grinder.communication.MessageRequiringResponse;
import net.grinder.communication.NoResponseMessage;
import net.grinder.communication.Sender;
import net.grinder.util.ListenerSupport;

public final class MessageDispatchSender
implements Sender,
MessageDispatchRegistry {
    private final Map<Class<? extends Message>, MessageDispatchRegistry.Handler<Message>> m_handlers = Collections.synchronizedMap(new HashMap());
    private final Map<Class<? extends Message>, MessageDispatchRegistry.BlockingHandler<Message>> m_responders = Collections.synchronizedMap(new HashMap());
    private final ListenerSupport<MessageDispatchRegistry.Handler<Message>> m_fallbackHandlers = new ListenerSupport();

    @Override
    public <T extends Message, S extends T> MessageDispatchRegistry.Handler<T> set(Class<S> messageType, MessageDispatchRegistry.Handler<T> messageHandler) {
        return this.m_handlers.put(messageType, messageHandler);
    }

    @Override
    public <T extends Message, S extends T> MessageDispatchRegistry.BlockingHandler<T> set(Class<S> messageType, MessageDispatchRegistry.BlockingHandler<T> responder) {
        return this.m_responders.put(messageType, responder);
    }

    @Override
    public void addFallback(MessageDispatchRegistry.Handler<Message> messageHandler) {
        this.m_fallbackHandlers.add(messageHandler);
    }

    @Override
    public void send(final Message message) throws CommunicationException {
        MessageRequiringResponse messageRequringResponse;
        if (message instanceof MessageRequiringResponse) {
            MessageRequiringResponse messageRequringResponse2 = (MessageRequiringResponse)message;
            Message requestMessage = messageRequringResponse2.getMessage();
            MessageDispatchRegistry.BlockingHandler<Message> responder = this.m_responders.get(requestMessage.getClass());
            if (responder != null) {
                messageRequringResponse2.sendResponse(responder.blockingSend(requestMessage));
                return;
            }
        } else {
            MessageDispatchRegistry.Handler<Message> handler = this.m_handlers.get(message.getClass());
            if (handler != null) {
                handler.handle(message);
                return;
            }
        }
        final CommunicationException[] exception = new CommunicationException[1];
        this.m_fallbackHandlers.apply(new ListenerSupport.Informer<MessageDispatchRegistry.Handler<Message>>(){

            @Override
            public void inform(MessageDispatchRegistry.Handler<Message> handler) {
                try {
                    handler.handle(message);
                }
                catch (CommunicationException e) {
                    exception[0] = e;
                }
            }
        });
        if (message instanceof MessageRequiringResponse && !(messageRequringResponse = (MessageRequiringResponse)message).isResponseSent()) {
            messageRequringResponse.sendResponse(new NoResponseMessage());
        }
        if (exception[0] != null) {
            throw exception[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        ArrayList<MessageDispatchRegistry.BlockingHandler<Message>> responders;
        ArrayList<MessageDispatchRegistry.Handler<Message>> handlers;
        Map<Class<? extends Message>, MessageDispatchRegistry.Handler<Message>> map = this.m_handlers;
        synchronized (map) {
            handlers = new ArrayList<MessageDispatchRegistry.Handler<Message>>(this.m_handlers.values());
        }
        for (MessageDispatchRegistry.Handler handler : handlers) {
            handler.shutdown();
        }
        Map<Class<? extends Message>, MessageDispatchRegistry.BlockingHandler<Message>> map2 = this.m_responders;
        synchronized (map2) {
            responders = new ArrayList<MessageDispatchRegistry.BlockingHandler<Message>>(this.m_responders.values());
        }
        for (MessageDispatchRegistry.BlockingHandler blockingHandler : responders) {
            blockingHandler.shutdown();
        }
        this.m_fallbackHandlers.apply(new ListenerSupport.Informer<MessageDispatchRegistry.Handler<Message>>(){

            @Override
            public void inform(MessageDispatchRegistry.Handler<Message> handler) {
                handler.shutdown();
            }
        });
    }
}

