/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.communication;

import java.io.OutputStream;
import java.util.concurrent.ExecutorService;
import net.grinder.communication.AbstractFanOutSender;
import net.grinder.communication.Acceptor;
import net.grinder.communication.Address;
import net.grinder.communication.CommunicationException;
import net.grinder.communication.ConnectionType;
import net.grinder.communication.Message;
import net.grinder.communication.ResourcePool;
import net.grinder.communication.SocketWrapper;
import net.grinder.util.thread.ExecutorFactory;

public final class FanOutServerSender
extends AbstractFanOutSender {
    public FanOutServerSender(Acceptor acceptor, ConnectionType connectionType, int numberOfThreads) throws Acceptor.ShutdownException {
        this(acceptor.getSocketSet(connectionType), ExecutorFactory.createThreadPool("FanOutServerSender for " + (Object)((Object)connectionType), numberOfThreads));
    }

    private FanOutServerSender(ResourcePool acceptedSockets, ExecutorService executor) {
        super(executor, acceptedSockets);
    }

    public void send(Address address, Message message) throws CommunicationException {
        if (this.isShutdown()) {
            throw new CommunicationException("Shut down");
        }
        this.writeAddressedMessage(address, message);
    }

    @Override
    protected OutputStream resourceToOutputStream(ResourcePool.Resource resource) throws CommunicationException {
        return ((SocketWrapper)resource).getOutputStream();
    }

    @Override
    protected Address getAddress(ResourcePool.Resource resource) {
        return ((SocketWrapper)resource).getAddress();
    }
}

