/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.communication;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import net.grinder.common.UncheckedInterruptedException;
import net.grinder.communication.CommunicationException;
import net.grinder.communication.ConnectionIdentity;
import net.grinder.communication.ConnectionType;
import net.grinder.communication.Connector;
import net.grinder.communication.IdleAwareSocketWrapper;
import net.grinder.communication.ResourcePool;
import net.grinder.communication.ResourcePoolImplementation;
import net.grinder.communication.SocketWrapper;
import net.grinder.util.ListenerSupport;
import net.grinder.util.TimeAuthority;
import net.grinder.util.thread.ExecutorFactory;
import net.grinder.util.thread.InterruptibleRunnable;
import net.grinder.util.thread.InterruptibleRunnableAdapter;

public final class Acceptor {
    private final ServerSocket m_serverSocket;
    private final ExecutorService m_executor;
    private final BlockingQueue<Exception> m_exceptionQueue = new ArrayBlockingQueue<Exception>(10);
    private final Map<ConnectionType, ResourcePool> m_socketSets = new HashMap<ConnectionType, ResourcePool>();
    private final Map<ConnectionType, ListenerSupport<Listener>> m_listenerMap = new HashMap<ConnectionType, ListenerSupport<Listener>>();
    private boolean m_isShutdown = false;
    private final TimeAuthority m_timeAuthority;

    public Acceptor(String addressString, int port, int numberOfThreads, TimeAuthority timeAuthority) throws CommunicationException {
        this.m_timeAuthority = timeAuthority;
        if (addressString.length() > 0) {
            try {
                this.m_serverSocket = new ServerSocket(port, 50, InetAddress.getByName(addressString));
            }
            catch (IOException e) {
                UncheckedInterruptedException.ioException(e);
                throw new CommunicationException("Could not bind to address '" + addressString + ':' + port + '\'', e);
            }
        }
        try {
            this.m_serverSocket = new ServerSocket(port, 50);
        }
        catch (IOException e) {
            UncheckedInterruptedException.ioException(e);
            throw new CommunicationException("Could not bind to port '" + port + "' on local interfaces", e);
        }
        this.m_executor = ExecutorFactory.createThreadPool("Acceptor", numberOfThreads);
        for (int i = 0; i < numberOfThreads; ++i) {
            this.m_executor.submit(new InterruptibleRunnableAdapter(new AcceptorRunnable()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() throws CommunicationException {
        Map<ConnectionType, ResourcePool> map = this.m_socketSets;
        synchronized (map) {
            if (this.m_isShutdown) {
                return;
            }
            this.m_isShutdown = true;
        }
        try {
            this.m_serverSocket.close();
        }
        catch (IOException e) {
            UncheckedInterruptedException.ioException(e);
            throw new CommunicationException("Error closing socket", e);
        }
        finally {
            this.m_executor.shutdownNow();
            ResourcePool[] socketSets = this.cloneListOfSocketSets();
            for (int i = 0; i < socketSets.length; ++i) {
                socketSets[i].closeCurrentResources();
            }
            this.m_exceptionQueue.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResourcePool[] cloneListOfSocketSets() {
        ResourcePool[] resourcePools;
        Map<ConnectionType, ResourcePool> map = this.m_socketSets;
        synchronized (map) {
            resourcePools = this.m_socketSets.values().toArray(new ResourcePool[this.m_socketSets.size()]);
        }
        return resourcePools;
    }

    public int getPort() {
        return this.m_serverSocket.getLocalPort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Exception getPendingException() {
        Map<ConnectionType, ResourcePool> map = this.m_socketSets;
        synchronized (map) {
            if (this.m_isShutdown) {
                return null;
            }
        }
        try {
            return this.m_exceptionQueue.take();
        }
        catch (InterruptedException e) {
            throw new UncheckedInterruptedException(e);
        }
    }

    Exception peekPendingException() {
        return (Exception)this.m_exceptionQueue.peek();
    }

    public int getNumberOfConnections() {
        ResourcePool[] socketSets = this.cloneListOfSocketSets();
        int result = 0;
        for (int i = 0; i < socketSets.length; ++i) {
            result += socketSets[i].countActive();
        }
        return result;
    }

    public void addListener(ConnectionType connectionType, Listener listener) {
        this.getListeners(connectionType).add(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ResourcePool getSocketSet(final ConnectionType connectionType) throws ShutdownException {
        Map<ConnectionType, ResourcePool> map = this.m_socketSets;
        synchronized (map) {
            if (this.m_isShutdown) {
                throw new ShutdownException("Acceptor has been shut down");
            }
            ResourcePool original = this.m_socketSets.get((Object)connectionType);
            if (original != null) {
                return original;
            }
            ResourcePoolImplementation newSocketSet = new ResourcePoolImplementation();
            newSocketSet.addListener(new ResourcePool.Listener(){

                @Override
                public void resourceAdded(ResourcePool.Resource resource) {
                    final ConnectionIdentity connection = ((SocketWrapper)resource).getConnectionIdentity();
                    Acceptor.this.getListeners(connectionType).apply(new ListenerSupport.Informer<Listener>(){

                        @Override
                        public void inform(Listener l) {
                            l.connectionAccepted(connectionType, connection);
                        }
                    });
                }

                @Override
                public void resourceClosed(ResourcePool.Resource resource) {
                    final ConnectionIdentity connection = ((SocketWrapper)resource).getConnectionIdentity();
                    Acceptor.this.getListeners(connectionType).apply(new ListenerSupport.Informer<Listener>(){

                        @Override
                        public void inform(Listener l) {
                            l.connectionClosed(connectionType, connection);
                        }
                    });
                }
            });
            this.m_socketSets.put(connectionType, newSocketSet);
            return newSocketSet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ListenerSupport<Listener> getListeners(ConnectionType connectionType) {
        Map<ConnectionType, ListenerSupport<Listener>> map = this.m_listenerMap;
        synchronized (map) {
            ListenerSupport<Listener> original = this.m_listenerMap.get((Object)connectionType);
            if (original != null) {
                return original;
            }
            ListenerSupport<Listener> newList = new ListenerSupport<Listener>();
            this.m_listenerMap.put(connectionType, newList);
            return newList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void discriminateConnection(Socket localSocket) throws IOException, ShutdownException {
        boolean closeSocket = true;
        try {
            Connector.ConnectDetails connectDetails = Connector.read(localSocket.getInputStream());
            IdleAwareSocketWrapper socketWrapper = new IdleAwareSocketWrapper(localSocket, this.m_timeAuthority);
            socketWrapper.setAddress(connectDetails.getAddress());
            final ResourcePool.Closeable closeable = this.getSocketSet(connectDetails.getConnectionType()).add(socketWrapper);
            socketWrapper.addClosedListener(new SocketWrapper.ClosedListener(){

                @Override
                public void socketClosed() {
                    closeable.close();
                }
            });
            closeSocket = false;
        }
        catch (CommunicationException e) {
            try {
                this.m_exceptionQueue.put(e);
            }
            catch (InterruptedException ie) {
                throw new UncheckedInterruptedException(ie);
            }
        }
        finally {
            if (closeSocket) {
                try {
                    localSocket.close();
                }
                catch (IOException ioException) {
                    UncheckedInterruptedException.ioException(ioException);
                }
            }
        }
    }

    public static final class ShutdownException
    extends CommunicationException {
        private ShutdownException(String s) {
            super(s);
        }
    }

    private class AcceptorRunnable
    implements InterruptibleRunnable {
        private AcceptorRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        @Override
        public void interruptibleRun() {
            try {
                while (true) {
                    Socket localSocket = Acceptor.this.m_serverSocket.accept();
                    Acceptor.this.discriminateConnection(localSocket);
                }
            }
            catch (IOException e) {
                try {
                    Acceptor.this.shutdown();
                }
                catch (CommunicationException e2) {}
            }
            catch (ShutdownException e) {
                try {
                    Acceptor.this.shutdown();
                }
                catch (CommunicationException communicationException) {}
                catch (Throwable throwable) {
                    try {
                        Acceptor.this.shutdown();
                    }
                    catch (CommunicationException communicationException) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
        }
    }

    public static interface Listener {
        public void connectionAccepted(ConnectionType var1, ConnectionIdentity var2);

        public void connectionClosed(ConnectionType var1, ConnectionIdentity var2);
    }
}

