/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.common.processidentity;

import java.util.Comparator;
import net.grinder.common.processidentity.ProcessAddress;
import net.grinder.common.processidentity.ProcessIdentity;

public interface ProcessReport {
    public ProcessAddress<? extends ProcessIdentity> getProcessAddress();

    public State getState();

    public static final class StateThenNameThenNumberComparator
    implements Comparator<ProcessReport> {
        @Override
        public int compare(ProcessReport processReport1, ProcessReport processReport2) {
            int stateComparison = processReport1.getState().compareTo(processReport2.getState());
            if (stateComparison == 0) {
                ProcessIdentity identity1 = processReport1.getProcessAddress().getIdentity();
                ProcessIdentity identity2 = processReport2.getProcessAddress().getIdentity();
                int nameComparison = identity1.getName().compareTo(identity2.getName());
                if (nameComparison == 0) {
                    return identity1.getNumber() - identity2.getNumber();
                }
                return nameComparison;
            }
            return stateComparison;
        }
    }

    public static enum State {
        STARTED,
        RUNNING,
        FINISHED,
        UNKNOWN;

    }
}

