/*
 * Decompiled with CFR 0.152.
 */
package net.grinder;

import java.io.File;
import net.grinder.common.GrinderException;
import net.grinder.engine.agent.Agent;
import net.grinder.engine.agent.AgentDaemon;
import net.grinder.engine.agent.AgentImplementation;
import net.grinder.util.AbstractMainClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Grinder
extends AbstractMainClass {
    private static final String USAGE = "  java " + Grinder.class.getName() + " <options> [alternatePropertiesFilename]" + "\n\n" + "Options:" + "\n  [-daemon [n]]                Run agent in deamon mode; try to" + "\n                               reconnect every n seconds (default 60)." + "\n\n";
    private final Agent m_agent;

    public static void main(String[] args) {
        Logger logger = LoggerFactory.getLogger((String)"agent");
        try {
            Grinder grinder = new Grinder(args, logger);
            grinder.run();
        }
        catch (AbstractMainClass.LoggedInitialisationException e) {
            System.exit(1);
        }
        catch (Throwable e) {
            logger.error(e.getMessage(), e);
            System.exit(2);
        }
        System.exit(0);
    }

    private Grinder(String[] args, Logger logger) throws GrinderException {
        super(logger, USAGE);
        File propertiesFile = null;
        long daemonPeriod = -1L;
        for (int i = 0; i < args.length; ++i) {
            if ("-daemon".equalsIgnoreCase(args[i])) {
                daemonPeriod = 60000L;
                try {
                    daemonPeriod = (long)Integer.parseInt(args[i + 1]) * 1000L;
                    ++i;
                }
                catch (IndexOutOfBoundsException e) {
                }
                catch (NumberFormatException e) {}
                continue;
            }
            if (i == args.length - 1 && !args[i].startsWith("-")) {
                propertiesFile = new File(args[i]);
                continue;
            }
            throw this.barfUsage();
        }
        this.m_agent = daemonPeriod > -1L ? new AgentDaemon(logger, daemonPeriod, new AgentImplementation(logger, propertiesFile, false)) : new AgentImplementation(logger, propertiesFile, true);
    }

    private void run() throws GrinderException {
        this.m_agent.run();
        this.m_agent.shutdown();
    }
}

