/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.util.weave.j2se6;

import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.ProtectionDomain;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import net.grinder.util.Pair;
import net.grinder.util.weave.Weaver;
import net.grinder.util.weave.WeavingException;
import net.grinder.util.weave.j2se6.DCRWeaver;
import net.grinder.util.weave.j2se6.PointCutRegistry;
import net.grinder.util.weave.j2se6.WeavingDetails;
import org.objectweb.asm.ClassAdapter;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodAdapter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;

public final class ASMTransformerFactory
implements DCRWeaver.ClassFileTransformerFactory {
    private final String m_adviceClass;
    private Map<Weaver.TargetSource, TargetExtractor> m_extractors = new HashMap<Weaver.TargetSource, TargetExtractor>(){
        {
            this.put(Weaver.TargetSource.CLASS, new ClassTargetExtractor());
            this.put(Weaver.TargetSource.FIRST_PARAMETER, new LocalVariableTargetExtractor(0));
            this.put(Weaver.TargetSource.SECOND_PARAMETER, new LocalVariableTargetExtractor(1));
            this.put(Weaver.TargetSource.THIRD_PARAMETER, new LocalVariableTargetExtractor(2));
        }
    };

    public ASMTransformerFactory(Class<?> adviceClass) throws WeavingException {
        try {
            Method enterMethod = adviceClass.getMethod("enter", Object.class, String.class);
            if (!Modifier.isStatic(enterMethod.getModifiers())) {
                throw new WeavingException("Enter method is not static");
            }
            Method exitMethod = adviceClass.getMethod("exit", Object.class, String.class, Boolean.TYPE);
            if (!Modifier.isStatic(exitMethod.getModifiers())) {
                throw new WeavingException("Exit method is not static");
            }
        }
        catch (Exception e) {
            throw new WeavingException(adviceClass.getName() + " does not expected enter and exit methods", e);
        }
        this.m_adviceClass = Type.getInternalName(adviceClass);
    }

    @Override
    public ClassFileTransformer create(PointCutRegistry pointCutRegistry) {
        return new ASMTransformer(pointCutRegistry);
    }

    private final class AdviceMethodVisitor
    extends MethodAdapter
    implements ContextMethodVisitor,
    Opcodes {
        private final Type m_internalClassType;
        private final List<WeavingDetails> m_weavingDetails;
        private final Label m_entryLabel;
        private final Label m_exceptionExitLabel;
        private boolean m_tryCatchBlockNeeded;
        private boolean m_entryCallNeeded;

        private AdviceMethodVisitor(MethodVisitor mv, Type internalClassType, int access, String name, List<WeavingDetails> weavingDetails) {
            super(mv);
            this.m_entryLabel = new Label();
            this.m_exceptionExitLabel = new Label();
            this.m_tryCatchBlockNeeded = true;
            this.m_entryCallNeeded = true;
            this.m_internalClassType = internalClassType;
            this.m_weavingDetails = weavingDetails;
        }

        private void generateTryCatchBlock() {
            if (this.m_tryCatchBlockNeeded) {
                super.visitTryCatchBlock(this.m_entryLabel, this.m_exceptionExitLabel, this.m_exceptionExitLabel, null);
                this.m_tryCatchBlockNeeded = false;
            }
        }

        @Override
        public Type getInternalClassName() {
            return this.m_internalClassType;
        }

        private void generateEntryCall() {
            if (this.m_entryCallNeeded) {
                this.m_entryCallNeeded = false;
                super.visitLabel(this.m_entryLabel);
                for (WeavingDetails weavingDetails : this.m_weavingDetails) {
                    ((TargetExtractor)ASMTransformerFactory.this.m_extractors.get((Object)weavingDetails.getTargetSource())).extract(this);
                    super.visitLdcInsn((Object)weavingDetails.getLocation());
                    super.visitMethodInsn(184, ASMTransformerFactory.this.m_adviceClass, "enter", "(Ljava/lang/Object;Ljava/lang/String;)V");
                }
            }
        }

        private void generateEntryBlocks() {
            this.generateTryCatchBlock();
            this.generateEntryCall();
        }

        private void generateExitCall(boolean success) {
            ListIterator<WeavingDetails> i = this.m_weavingDetails.listIterator(this.m_weavingDetails.size());
            while (i.hasPrevious()) {
                WeavingDetails weavingDetails = i.previous();
                ((TargetExtractor)ASMTransformerFactory.this.m_extractors.get((Object)weavingDetails.getTargetSource())).extract(this);
                super.visitLdcInsn((Object)weavingDetails.getLocation());
                super.visitInsn(success ? 4 : 3);
                super.visitMethodInsn(184, ASMTransformerFactory.this.m_adviceClass, "exit", "(Ljava/lang/Object;Ljava/lang/String;Z)V");
            }
        }

        public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
            super.visitTryCatchBlock(start, end, handler, type);
            this.generateTryCatchBlock();
        }

        public void visitLabel(Label label) {
            this.generateEntryBlocks();
            super.visitLabel(label);
        }

        public void visitFrame(int type, int nLocal, Object[] local, int nStack, Object[] stack) {
            this.generateEntryBlocks();
            super.visitFrame(type, nLocal, local, nStack, stack);
        }

        public void visitInsn(int opcode) {
            this.generateEntryBlocks();
            switch (opcode) {
                case 172: 
                case 173: 
                case 174: 
                case 175: 
                case 176: 
                case 177: {
                    this.generateExitCall(true);
                    break;
                }
            }
            super.visitInsn(opcode);
        }

        public void visitIntInsn(int opcode, int operand) {
            this.generateEntryBlocks();
            super.visitIntInsn(opcode, operand);
        }

        public void visitVarInsn(int opcode, int var) {
            this.generateEntryBlocks();
            super.visitVarInsn(opcode, var);
        }

        public void visitTypeInsn(int opcode, String type) {
            this.generateEntryBlocks();
            super.visitTypeInsn(opcode, type);
        }

        public void visitFieldInsn(int opcode, String owner, String name, String desc) {
            this.generateEntryBlocks();
            super.visitFieldInsn(opcode, owner, name, desc);
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc) {
            this.generateEntryBlocks();
            super.visitMethodInsn(opcode, owner, name, desc);
        }

        public void visitJumpInsn(int opcode, Label label) {
            this.generateEntryBlocks();
            super.visitJumpInsn(opcode, label);
        }

        public void visitLdcInsn(Object cst) {
            this.generateEntryBlocks();
            super.visitLdcInsn(cst);
        }

        public void visitIincInsn(int var, int increment) {
            this.generateEntryBlocks();
            super.visitIincInsn(var, increment);
        }

        public void visitTableSwitchInsn(int min, int max, Label dflt, Label[] labels) {
            this.generateEntryBlocks();
            super.visitTableSwitchInsn(min, max, dflt, labels);
        }

        public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
            this.generateEntryBlocks();
            super.visitLookupSwitchInsn(dflt, keys, labels);
        }

        public void visitMultiANewArrayInsn(String desc, int dims) {
            this.generateEntryBlocks();
            super.visitMultiANewArrayInsn(desc, dims);
        }

        public void visitMaxs(int maxStack, int maxLocals) {
            super.visitLabel(this.m_exceptionExitLabel);
            this.generateExitCall(false);
            super.visitInsn(191);
            super.visitMaxs(maxStack, maxLocals);
        }
    }

    private static interface ContextMethodVisitor
    extends MethodVisitor {
        public Type getInternalClassName();
    }

    private static class ClassTargetExtractor
    implements TargetExtractor {
        private ClassTargetExtractor() {
        }

        @Override
        public void extract(ContextMethodVisitor methodVisitor) {
            methodVisitor.visitLdcInsn(methodVisitor.getInternalClassName());
        }
    }

    private static class LocalVariableTargetExtractor
    implements TargetExtractor {
        private final int m_variableNumber;

        public LocalVariableTargetExtractor(int variableNumber) {
            this.m_variableNumber = variableNumber;
        }

        @Override
        public void extract(ContextMethodVisitor methodVisitor) {
            methodVisitor.visitVarInsn(25, this.m_variableNumber);
        }
    }

    private static interface TargetExtractor {
        public void extract(ContextMethodVisitor var1);
    }

    private final class AddAdviceClassAdapter
    extends ClassAdapter {
        private final Type m_internalClassType;
        private final Map<Pair<String, String>, List<WeavingDetails>> m_weavingDetails;

        private AddAdviceClassAdapter(ClassVisitor classVisitor, Type internalClassType, Map<Pair<String, String>, List<WeavingDetails>> weavingDetails) {
            super(classVisitor);
            this.m_internalClassType = internalClassType;
            this.m_weavingDetails = weavingDetails;
        }

        public void visit(int originalVersion, int access, String name, String signature, String superName, String[] interfaces) {
            this.cv.visit(Math.max(originalVersion & 0xFFFF, 49), access, name, signature, superName, interfaces);
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            MethodVisitor defaultVisitor = this.cv.visitMethod(access, name, desc, signature, exceptions);
            List<WeavingDetails> weavingDetails = this.m_weavingDetails.get(Pair.of(name, desc));
            if (weavingDetails != null) {
                assert (defaultVisitor != null);
                return new AdviceMethodVisitor(defaultVisitor, this.m_internalClassType, access, name, weavingDetails);
            }
            return defaultVisitor;
        }
    }

    private class ASMTransformer
    implements ClassFileTransformer {
        private final PointCutRegistry m_pointCutRegistry;

        public ASMTransformer(PointCutRegistry pointCutRegistry) {
            this.m_pointCutRegistry = pointCutRegistry;
        }

        @Override
        public byte[] transform(ClassLoader loader, String internalClassName, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] originalBytes) throws IllegalClassFormatException {
            ClassWriter classWriter;
            Map<Method, List<WeavingDetails>> methodToWeavingDetails;
            Map<Constructor<?>, List<WeavingDetails>> constructorToWeavingDetails = this.m_pointCutRegistry.getConstructorPointCutsForClass(internalClassName);
            int size = (constructorToWeavingDetails != null ? constructorToWeavingDetails.size() : 0) + ((methodToWeavingDetails = this.m_pointCutRegistry.getMethodPointCutsForClass(internalClassName)) != null ? methodToWeavingDetails.size() : 0);
            if (size == 0) {
                return null;
            }
            HashMap<Pair<String, String>, List<WeavingDetails>> nameAndDescriptionToWeavingDetails = new HashMap<Pair<String, String>, List<WeavingDetails>>(size);
            if (constructorToWeavingDetails != null) {
                for (Map.Entry<Executable, List<WeavingDetails>> entry : constructorToWeavingDetails.entrySet()) {
                    Constructor c = (Constructor)entry.getKey();
                    nameAndDescriptionToWeavingDetails.put(Pair.of("<init>", Type.getConstructorDescriptor((Constructor)c)), entry.getValue());
                }
            }
            if (methodToWeavingDetails != null) {
                for (Map.Entry<Executable, List<WeavingDetails>> entry : methodToWeavingDetails.entrySet()) {
                    Method m = (Method)entry.getKey();
                    nameAndDescriptionToWeavingDetails.put(Pair.of(m.getName(), Type.getMethodDescriptor((Method)m)), entry.getValue());
                }
            }
            ClassReader classReader = new ClassReader(originalBytes);
            Object visitorChain = classWriter = new ClassWriter(classReader, 2);
            visitorChain = new AddAdviceClassAdapter((ClassVisitor)visitorChain, Type.getType((String)("L" + internalClassName + ";")), nameAndDescriptionToWeavingDetails);
            classReader.accept((ClassVisitor)visitorChain, 0);
            return classWriter.toByteArray();
        }
    }
}

