/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.util;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public final class ListenerSupport<T> {
    private final List<T> m_listeners = new LinkedList<T>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(T listener) {
        List<T> list = this.m_listeners;
        synchronized (list) {
            this.m_listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(T listener) {
        List<T> list = this.m_listeners;
        synchronized (list) {
            while (this.m_listeners.remove(listener)) {
            }
        }
    }

    public void apply(Informer<? super T> informer) {
        for (T listener : this.cloneListenerList()) {
            informer.inform(listener);
        }
    }

    public boolean apply(HandlingInformer<? super T> handler) {
        for (T listener : this.cloneListenerList()) {
            if (!handler.inform(listener)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<T> cloneListenerList() {
        List<T> list = this.m_listeners;
        synchronized (list) {
            return new ArrayList<T>(this.m_listeners);
        }
    }

    public static interface HandlingInformer<K> {
        public boolean inform(K var1);
    }

    public static interface Informer<K> {
        public void inform(K var1);
    }
}

