/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.util;

import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import net.grinder.common.GrinderBuild;
import net.grinder.common.GrinderException;
import org.slf4j.Logger;

public final class JVM {
    public static JVM getInstance() {
        return new JVM();
    }

    private JVM() {
    }

    public boolean haveRequisites(Logger logger) throws VersionException {
        String name = "The Grinder " + GrinderBuild.getVersionString();
        if (!this.isAtLeastVersion(1, 6)) {
            logger.error("Fatal Error - incompatible version of Java ({})%n{} requires at least Java SE 6.", (Object)this, (Object)name);
            return false;
        }
        return true;
    }

    public boolean isAtLeastVersion(int minimumMajor, int minimumMinor) throws VersionException {
        String version = System.getProperty("java.version");
        StringTokenizer versionTokenizer = new StringTokenizer(version, ".");
        try {
            int major = Integer.parseInt(versionTokenizer.nextToken());
            int minor = Integer.parseInt(versionTokenizer.nextToken());
            return major >= minimumMajor && minor >= minimumMinor;
        }
        catch (NoSuchElementException e) {
            throw new VersionException("Could not parse JVM version " + version);
        }
        catch (NumberFormatException e) {
            throw new VersionException("Could not parse JVM version " + version);
        }
    }

    public String toString() {
        return System.getProperty("java.runtime.name") + " " + System.getProperty("java.runtime.version") + ": " + System.getProperty("java.vm.name") + " (" + System.getProperty("java.vm.version") + ", " + System.getProperty("java.vm.info") + ") on " + System.getProperty("os.name") + " " + System.getProperty("os.arch") + " " + System.getProperty("os.version");
    }

    public static final class VersionException
    extends GrinderException {
        public VersionException(String reason) {
            super(reason);
        }
    }
}

