/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.util;

import net.grinder.util.AbstractMultiLineFormatter;

public final class FixedWidthFormatter
extends AbstractMultiLineFormatter {
    private final Align m_alignment;
    private final Flow m_flow;
    private final int m_width;

    public FixedWidthFormatter(Align alignment, Flow flow, int width) {
        if (width <= 0) {
            throw new IllegalArgumentException("Invalid width value");
        }
        this.m_alignment = alignment;
        this.m_flow = flow;
        this.m_width = width;
    }

    @Override
    public void transform(StringBuilder buffer, StringBuilder remainder) {
        this.m_flow.flow(buffer, remainder, this.m_width);
        int length = buffer.length();
        for (int k = 0; k < length; ++k) {
            if (!Character.isWhitespace(buffer.charAt(k))) continue;
            buffer.setCharAt(k, ' ');
        }
        if (length < this.m_width) {
            this.m_alignment.pad(buffer, this.m_width - length);
        }
    }

    public static enum Flow {
        TRUNCATE{

            @Override
            void flow(StringBuilder buffer, StringBuilder remainder, int width) {
                if (buffer.length() > width) {
                    buffer.setLength(width);
                }
            }
        }
        ,
        WRAP{

            @Override
            void flow(StringBuilder buffer, StringBuilder remainder, int width) {
                if (buffer.length() > width) {
                    remainder.insert(0, buffer.substring(width));
                    buffer.setLength(width);
                }
            }
        }
        ,
        WORD_WRAP{

            private int findWordWrapSplitPosition(StringBuilder buffer, int width) {
                int splitPosition;
                int length = buffer.length();
                int right = Math.min(length, width);
                for (splitPosition = 0; splitPosition < right; ++splitPosition) {
                    if (buffer.charAt(splitPosition) != '\n') continue;
                    return splitPosition;
                }
                if (length > width) {
                    splitPosition = width;
                    do {
                        if (!Character.isWhitespace(buffer.charAt(splitPosition))) continue;
                        return splitPosition;
                    } while (--splitPosition >= 0);
                    return width;
                }
                return length;
            }

            @Override
            void flow(StringBuilder buffer, StringBuilder remainder, int width) {
                int splitPosition;
                char c;
                int nextText;
                int length = buffer.length();
                for (nextText = splitPosition = this.findWordWrapSplitPosition(buffer, width); nextText < length && Character.isWhitespace(c = buffer.charAt(nextText)); ++nextText) {
                    if (c != '\n') continue;
                    break;
                }
                if (nextText < length) {
                    remainder.insert(0, buffer.substring(nextText));
                }
                buffer.setLength(splitPosition);
            }
        }
        ,
        OVERFLOW{

            @Override
            void flow(StringBuilder buffer, StringBuilder remainder, int width) {
            }
        };


        abstract void flow(StringBuilder var1, StringBuilder var2, int var3);
    }

    public static enum Align {
        LEFT{

            @Override
            void pad(StringBuilder buffer, int remainder) {
                buffer.append(s_space, 0, remainder);
            }
        }
        ,
        CENTRE{

            @Override
            void pad(StringBuilder buffer, int remainder) {
                int charsLeft = (remainder + 1) / 2;
                int charsRight = remainder / 2;
                buffer.insert(0, s_space, 0, charsLeft);
                buffer.append(s_space, 0, charsRight);
            }
        }
        ,
        RIGHT{

            @Override
            void pad(StringBuilder buffer, int remainder) {
                buffer.insert(0, s_space, 0, remainder);
            }
        };

        private static final char[] s_space;

        abstract void pad(StringBuilder var1, int var2);

        static {
            s_space = new char[256];
            for (int i = 0; i < s_space.length; ++i) {
                Align.s_space[i] = 32;
            }
        }
    }
}

