/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import net.grinder.common.Closer;
import net.grinder.common.GrinderException;
import net.grinder.common.UncheckedInterruptedException;
import net.grinder.util.Directory;
import net.grinder.util.StreamCopier;

public final class FileContents
implements Serializable {
    private static final long serialVersionUID = -3140708892260600117L;
    private final File m_filename;
    private final byte[] m_contents;

    public FileContents(File baseDirectory, File file) throws FileContentsException {
        if (file.isAbsolute()) {
            throw new FileContentsException("Original file name '" + file + "' is not relative");
        }
        this.m_filename = file;
        File localFile = new File(baseDirectory, file.getPath());
        ByteArrayOutputStream byteOutputStream = new ByteArrayOutputStream();
        try {
            new StreamCopier(4096, true).copy(new FileInputStream(localFile), byteOutputStream);
        }
        catch (IOException e) {
            UncheckedInterruptedException.ioException(e);
            throw new FileContentsException("Failed to read file: " + e.getMessage(), e);
        }
        this.m_contents = byteOutputStream.toByteArray();
    }

    File getFilename() {
        return this.m_filename;
    }

    byte[] getContents() {
        return this.m_contents;
    }

    public void create(Directory baseDirectory) throws FileContentsException {
        File localFile = baseDirectory.getFile(this.getFilename());
        localFile.getParentFile().mkdirs();
        FileOutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(localFile);
            ((OutputStream)outputStream).write(this.getContents());
        }
        catch (IOException e) {
            try {
                UncheckedInterruptedException.ioException(e);
                throw new FileContentsException("Failed to create file: " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                Closer.close(outputStream);
                throw throwable;
            }
        }
        Closer.close(outputStream);
    }

    public String toString() {
        return "\"" + this.getFilename() + "\" (" + this.getContents().length + " bytes)";
    }

    public static final class FileContentsException
    extends GrinderException {
        FileContentsException(String message) {
            super(message);
        }

        FileContentsException(String message, Throwable nested) {
            super(message, nested);
        }
    }
}

