/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.util;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;

public final class DelayedCreationFileWriter
extends Writer {
    private final File m_file;
    private final boolean m_append;
    private Writer m_delegate = null;

    public DelayedCreationFileWriter(File file, boolean append) {
        this.m_file = file;
        this.m_append = append;
        if (!append) {
            this.m_file.delete();
        }
    }

    @Override
    public void close() throws IOException {
        if (this.m_delegate == null) {
            return;
        }
        this.m_delegate.close();
    }

    @Override
    public void flush() throws IOException {
        if (this.m_delegate == null) {
            return;
        }
        this.m_delegate.flush();
    }

    @Override
    public void write(char[] bytes, int offset, int length) throws IOException {
        if (this.m_delegate == null) {
            this.m_delegate = new FileWriter(this.m_file.getPath(), this.m_append);
        }
        this.m_delegate.write(bytes, offset, length);
    }
}

