/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import net.grinder.engine.common.EngineException;

public class ClassLoaderUtilities {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> allResourceLines(ClassLoader classLoader, String resourceName) throws IOException {
        ArrayList<String> result = new ArrayList<String>();
        Enumeration<URL> resources = classLoader.getResources(resourceName);
        HashSet<String> seenURLs = new HashSet<String>();
        while (resources.hasMoreElements()) {
            URL url = resources.nextElement();
            String urlString = url.toString();
            if (seenURLs.contains(urlString)) continue;
            seenURLs.add(urlString);
            InputStream in = url.openStream();
            try {
                String line;
                BufferedReader reader = new BufferedReader(new InputStreamReader(in, "utf-8"));
                while ((line = reader.readLine()) != null) {
                    int comment = line.indexOf(35);
                    if (comment >= 0) {
                        line = line.substring(0, comment);
                    }
                    if ((line = line.trim()).length() <= 0) continue;
                    result.add(line);
                }
                reader.close();
            }
            finally {
                in.close();
            }
        }
        return result;
    }

    public static List<Class<?>> loadRegisteredImplementations(String resourceName, ClassLoader classLoader) throws EngineException {
        return ClassLoaderUtilities.loadRegisteredImplementations(resourceName, Object.class, classLoader);
    }

    public static <T> List<Class<? extends T>> loadRegisteredImplementations(String resourceName, Class<T> cls) throws EngineException {
        return ClassLoaderUtilities.loadRegisteredImplementations(resourceName, cls, cls.getClassLoader());
    }

    public static <T> List<Class<? extends T>> loadRegisteredImplementations(String resourceName, Class<T> cls, ClassLoader classLoader) throws EngineException {
        List<String> names;
        try {
            names = ClassLoaderUtilities.allResourceLines(classLoader, resourceName);
        }
        catch (IOException e) {
            throw new EngineException("Failed to load implementation", e);
        }
        HashSet<String> seen = new HashSet<String>(names.size());
        ArrayList<Class<T>> result = new ArrayList<Class<T>>(names.size());
        for (String implementationName : names) {
            if (!seen.add(implementationName)) continue;
            try {
                Class<?> implementationClass = Class.forName(implementationName);
                if (cls.isAssignableFrom(implementationClass)) {
                    result.add(implementationClass);
                    continue;
                }
                throw new EngineException(implementationName + " does not implement " + cls.getName());
            }
            catch (ClassNotFoundException e) {
                throw new EngineException("Could not load '" + implementationName + "'", e);
            }
        }
        return result;
    }
}

