/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.util;

import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class BlockingClassLoader
extends URLClassLoader {
    private final boolean m_respectGrandparents;
    private final Classes m_blocked;
    private final Classes m_isolated;
    private final Classes m_shared;

    private static URL[] join(List<URL> additionalClassPath, URL[] urls) {
        ArrayList<URL> classPath = new ArrayList<URL>(additionalClassPath);
        classPath.addAll(Arrays.asList(urls));
        return classPath.toArray(new URL[classPath.size()]);
    }

    public BlockingClassLoader(URLClassLoader parent, List<URL> additionalClassPath, Set<String> blocked, Set<String> isolated, Set<String> shared, boolean respectGrandparents) {
        super(BlockingClassLoader.join(additionalClassPath, parent.getURLs()), (ClassLoader)parent);
        this.m_blocked = new Classes(blocked);
        this.m_isolated = new Classes(isolated);
        this.m_shared = new Classes(shared);
        this.m_respectGrandparents = respectGrandparents;
    }

    public BlockingClassLoader(List<URL> additionalClassPath, Set<String> blocked, Set<String> isolated, Set<String> shared, boolean respectGrandparents) {
        this((URLClassLoader)BlockingClassLoader.class.getClassLoader(), additionalClassPath, blocked, isolated, shared, respectGrandparents);
    }

    public BlockingClassLoader(Set<String> blocked, Set<String> isolated, Set<String> shared, boolean respectGrandparents) {
        this(Collections.emptyList(), blocked, isolated, shared, respectGrandparents);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if (!this.m_shared.matches(name, false)) {
            if (this.m_respectGrandparents) {
                try {
                    return Class.forName(name, resolve, this.getParent().getParent());
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            if (this.m_blocked.matches(name, false)) {
                throw new ClassNotFoundException();
            }
            if (this.m_isolated.matches(name, false)) {
                BlockingClassLoader blockingClassLoader = this;
                synchronized (blockingClassLoader) {
                    Class<?> c = this.findLoadedClass(name);
                    if (c == null) {
                        c = this.findClass(name);
                    }
                    if (resolve) {
                        this.resolveClass(c);
                    }
                    return c;
                }
            }
        }
        return super.loadClass(name, resolve);
    }

    @Override
    public URL getResource(String name) {
        if (!this.m_shared.matches(name, true)) {
            URL grandParentResult;
            if (this.m_respectGrandparents && (grandParentResult = this.getParent().getParent().getResource(name)) != null) {
                return grandParentResult;
            }
            if (this.m_blocked.matches(name, true)) {
                return null;
            }
            if (this.m_isolated.matches(name, true)) {
                return this.findResource(name);
            }
        }
        return super.getResource(name);
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        if (!this.m_shared.matches(name, true)) {
            ArrayList<URL> result = new ArrayList<URL>();
            if (this.m_respectGrandparents) {
                result.addAll(Collections.list(this.getParent().getParent().getResources(name)));
            }
            if (this.m_blocked.matches(name, true)) {
                return Collections.enumeration(result);
            }
            if (this.m_isolated.matches(name, true)) {
                result.addAll(Collections.list(this.findResources(name)));
                return Collections.enumeration(result);
            }
        }
        return super.getResources(name);
    }

    private static class Classes {
        private final Set<String> m_classNames = new HashSet<String>();
        private final Set<String> m_prefixes = new HashSet<String>();

        public Classes(Set<String> wildcardNames) {
            for (String name : wildcardNames) {
                int index = name.indexOf(42);
                if (index >= 0) {
                    this.m_prefixes.add(name.substring(0, index));
                    continue;
                }
                this.m_classNames.add(name);
            }
        }

        public boolean matches(String name, boolean isResource) {
            String packageName;
            String string = packageName = isResource ? name.replace('/', '.') : name;
            if (this.m_classNames.contains(name)) {
                return true;
            }
            for (String prefix : this.m_prefixes) {
                if (!packageName.startsWith(prefix)) continue;
                return true;
            }
            return false;
        }
    }
}

