/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.synchronisation;

import java.util.Set;
import java.util.concurrent.TimeUnit;
import net.grinder.common.UncheckedInterruptedException;
import net.grinder.communication.CommunicationException;
import net.grinder.script.Barrier;
import net.grinder.script.CancelledBarrierException;
import net.grinder.synchronisation.BarrierGroup;
import net.grinder.synchronisation.messages.BarrierIdentity;
import net.grinder.util.thread.Condition;

public final class BarrierImplementation
implements Barrier,
BarrierGroup.Listener {
    private final BarrierGroup m_barrierGroup;
    private final BarrierIdentity.Factory m_identityFactory;
    private final Condition m_condition = new Condition();
    private State m_state = State.Idle;
    private BarrierIdentity m_identity;

    public BarrierImplementation(BarrierGroup group, BarrierIdentity.Factory identityFactory) throws CommunicationException {
        this.m_barrierGroup = group;
        this.m_identityFactory = identityFactory;
        this.m_identity = identityFactory.next();
        this.m_barrierGroup.addListener(this);
        this.m_barrierGroup.addBarrier();
    }

    private void changeState(State newState) {
        this.m_state = newState;
        this.m_condition.notifyAll();
    }

    @Override
    public void await() throws CancelledBarrierException, CommunicationException {
        new ForeverWaiter().await();
    }

    @Override
    public boolean await(long timeout, TimeUnit unit) throws CancelledBarrierException, CommunicationException {
        return new TimedWaiter(Math.max(1L, unit.toMillis(timeout))).await();
    }

    @Override
    public boolean await(long timeout) throws CancelledBarrierException, CommunicationException {
        return this.await(timeout, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void awaken(Set<BarrierIdentity> waiters) {
        Condition condition = this.m_condition;
        synchronized (condition) {
            if (waiters.contains(this.m_identity)) {
                this.m_state.awaken(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() throws CommunicationException {
        Condition condition = this.m_condition;
        synchronized (condition) {
            this.m_state.cancel(this);
        }
    }

    @Override
    public String getName() {
        return this.m_barrierGroup.getName();
    }

    private class TimedWaiter
    extends Waiter {
        private long m_time;

        public TimedWaiter(long timeMillis) {
            this.m_time = timeMillis;
        }

        @Override
        public boolean doWait() throws CommunicationException {
            long start = System.currentTimeMillis();
            try {
                BarrierImplementation.this.m_condition.wait(this.m_time);
            }
            catch (InterruptedException e) {
                BarrierImplementation.this.cancel();
                throw new UncheckedInterruptedException(e);
            }
            this.m_time -= System.currentTimeMillis() - start;
            return this.m_time < 1L;
        }
    }

    private class ForeverWaiter
    extends Waiter {
        private ForeverWaiter() {
        }

        @Override
        public boolean doWait() throws CommunicationException {
            try {
                BarrierImplementation.this.m_condition.wait();
            }
            catch (InterruptedException e) {
                BarrierImplementation.this.cancel();
                throw new UncheckedInterruptedException(e);
            }
            return true;
        }
    }

    private abstract class Waiter {
        private Waiter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean await() throws CancelledBarrierException, CommunicationException {
            Condition condition = BarrierImplementation.this.m_condition;
            synchronized (condition) {
                BarrierImplementation.this.m_state.beginWait(BarrierImplementation.this);
                BarrierImplementation.this.m_identity = BarrierImplementation.this.m_identityFactory.next();
                BarrierImplementation.this.m_barrierGroup.addWaiter(BarrierImplementation.this.m_identity);
                while (BarrierImplementation.this.m_state == State.Waiting && !this.doWait()) {
                }
                return BarrierImplementation.this.m_state.awoken(BarrierImplementation.this);
            }
        }

        protected abstract boolean doWait() throws CommunicationException;
    }

    private static enum State {
        Idle{

            @Override
            void beginWait(BarrierImplementation b) {
                b.changeState(1.Waiting);
            }

            @Override
            boolean awoken(BarrierImplementation b) throws CancelledBarrierException {
                return true;
            }
        }
        ,
        Waiting{

            @Override
            void beginWait(BarrierImplementation b) {
                throw new IllegalStateException("Another thread has called await()");
            }

            @Override
            boolean awoken(BarrierImplementation b) throws CommunicationException {
                b.cancel();
                return false;
            }
        }
        ,
        Cancelled{

            @Override
            void beginWait(BarrierImplementation b) throws CancelledBarrierException {
                throw new CancelledBarrierException("Barrier is cancelled");
            }

            @Override
            void awaken(BarrierImplementation b) {
            }

            @Override
            boolean awoken(BarrierImplementation b) throws CancelledBarrierException {
                throw new CancelledBarrierException("Cancelled while waiting");
            }

            @Override
            void cancel(BarrierImplementation b) {
            }
        };


        abstract void beginWait(BarrierImplementation var1) throws CancelledBarrierException;

        void awaken(BarrierImplementation b) {
            b.changeState(State.Idle);
        }

        abstract boolean awoken(BarrierImplementation var1) throws CancelledBarrierException, CommunicationException;

        void cancel(BarrierImplementation b) throws CommunicationException {
            b.changeState(State.Cancelled);
            b.m_barrierGroup.removeListener(b);
            b.m_barrierGroup.cancelWaiter(b.m_identity);
            b.m_barrierGroup.removeBarriers(1L);
        }
    }
}

