/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.statistics;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import net.grinder.common.AbstractTestSemantics;
import net.grinder.common.Test;
import net.grinder.statistics.StatisticsServicesImplementation;
import net.grinder.statistics.StatisticsSet;
import net.grinder.statistics.StatisticsSetFactory;
import net.grinder.statistics.StatisticsSetImplementation;

public final class TestStatisticsMap
implements Externalizable {
    private static final long serialVersionUID = 5L;
    private final transient StatisticsSetFactory m_statisticsSetFactory;
    private final Map<Test, StatisticsSet> m_data = new TreeMap<Test, StatisticsSet>();

    public TestStatisticsMap(StatisticsSetFactory statisticsSetFactory) {
        this.m_statisticsSetFactory = statisticsSetFactory;
    }

    public TestStatisticsMap() {
        this(StatisticsServicesImplementation.getInstance().getStatisticsSetFactory());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(Test test, StatisticsSet statistics) {
        if (!(statistics instanceof StatisticsSetImplementation)) {
            throw new AssertionError((Object)"StatisticsSet implementation not supported");
        }
        TestStatisticsMap testStatisticsMap = this;
        synchronized (testStatisticsMap) {
            this.m_data.put(test, statistics);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        TestStatisticsMap testStatisticsMap = this;
        synchronized (testStatisticsMap) {
            return this.m_data.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(TestStatisticsMap other) {
        TestStatisticsMap testStatisticsMap = other;
        synchronized (testStatisticsMap) {
            for (Map.Entry<Test, StatisticsSet> othersEntry : other.m_data.entrySet()) {
                StatisticsSet statistics;
                TestStatisticsMap testStatisticsMap2 = this;
                synchronized (testStatisticsMap2) {
                    StatisticsSet existingStatistics = this.m_data.get(othersEntry.getKey());
                    if (existingStatistics == null) {
                        statistics = this.m_statisticsSetFactory.create();
                        this.put(othersEntry.getKey(), statistics);
                    } else {
                        statistics = existingStatistics;
                    }
                }
                statistics.add(othersEntry.getValue());
            }
        }
    }

    public TestStatisticsMap reset() {
        final TestStatisticsMap result = new TestStatisticsMap(this.m_statisticsSetFactory);
        new ForEach(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void next(Test test, StatisticsSet statistics) {
                StatisticsSet snapshot;
                StatisticsSet statisticsSet = statistics;
                synchronized (statisticsSet) {
                    snapshot = statistics.snapshot();
                    statistics.reset();
                }
                if (!snapshot.isZero()) {
                    result.put(test, snapshot);
                }
            }
        }.iterate();
        return result;
    }

    public StatisticsSet nonCompositeStatisticsTotals() {
        final StatisticsSet result = this.m_statisticsSetFactory.create();
        new ForEach(){

            @Override
            public void next(Test test, StatisticsSet statistics) {
                if (!statistics.isComposite()) {
                    result.add(statistics);
                }
            }
        }.iterate();
        return result;
    }

    public StatisticsSet compositeStatisticsTotals() {
        final StatisticsSet result = this.m_statisticsSetFactory.create();
        new ForEach(){

            @Override
            public void next(Test test, StatisticsSet statistics) {
                if (statistics.isComposite()) {
                    result.add(statistics);
                }
            }
        }.iterate();
        return result;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != TestStatisticsMap.class) {
            return false;
        }
        TestStatisticsMap otherMap = (TestStatisticsMap)o;
        if (this.m_data.size() != otherMap.m_data.size()) {
            return false;
        }
        Iterator<Map.Entry<Test, StatisticsSet>> iterator = this.m_data.entrySet().iterator();
        Iterator<Map.Entry<Test, StatisticsSet>> otherIterator = otherMap.m_data.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Test, StatisticsSet> entry = iterator.next();
            Map.Entry<Test, StatisticsSet> otherEntry = otherIterator.next();
            if (entry.getKey().equals(otherEntry.getKey()) && entry.getValue().equals(otherEntry.getValue())) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        final StringBuilder result = new StringBuilder();
        result.append("TestStatisticsMap = {");
        new ForEach(){

            @Override
            public void next(Test test, StatisticsSet statisticsSet) {
                result.append("(");
                result.append(test);
                result.append(", ");
                result.append(statisticsSet);
                result.append(")");
            }
        }.iterate();
        result.append("}");
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        TestStatisticsMap testStatisticsMap = this;
        synchronized (testStatisticsMap) {
            out.writeInt(this.m_data.size());
            for (Map.Entry<Test, StatisticsSet> entry : this.m_data.entrySet()) {
                out.writeInt(entry.getKey().getNumber());
                this.m_statisticsSetFactory.writeStatisticsExternal(out, (StatisticsSetImplementation)entry.getValue());
            }
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        int n = in.readInt();
        this.m_data.clear();
        for (int i = 0; i < n; ++i) {
            this.m_data.put(new LightweightTest(in.readInt()), this.m_statisticsSetFactory.readStatisticsExternal(in));
        }
    }

    public abstract class ForEach {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void iterate() {
            TestStatisticsMap testStatisticsMap = TestStatisticsMap.this;
            synchronized (testStatisticsMap) {
                for (Map.Entry entry : TestStatisticsMap.this.m_data.entrySet()) {
                    this.next((Test)entry.getKey(), (StatisticsSet)entry.getValue());
                }
            }
        }

        protected abstract void next(Test var1, StatisticsSet var2);
    }

    private static final class LightweightTest
    extends AbstractTestSemantics {
        private final int m_number;

        public LightweightTest(int number) {
            this.m_number = number;
        }

        @Override
        public int getNumber() {
            return this.m_number;
        }

        @Override
        public String getDescription() {
            return "";
        }
    }
}

