/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.statistics;

import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import net.grinder.statistics.ExpressionView;

public final class StatisticsView {
    private static final Comparator<ExpressionView> s_expressionViewComparator = new CreationOrderComparator();
    private final Set<ExpressionView> m_unique = new HashSet<ExpressionView>();
    private final SortedSet<ExpressionView> m_columns = new TreeSet<ExpressionView>(s_expressionViewComparator);

    public synchronized void add(StatisticsView other) {
        for (ExpressionView expressionView : other.m_columns) {
            this.add(expressionView);
        }
    }

    public synchronized void add(ExpressionView statistic) {
        if (!this.m_unique.contains(statistic)) {
            this.m_unique.add(statistic);
            this.m_columns.add(statistic);
        }
    }

    public synchronized ExpressionView[] getExpressionViews() {
        return this.m_columns.toArray(new ExpressionView[this.m_columns.size()]);
    }

    static final class CreationOrderComparator
    implements Comparator<ExpressionView> {
        CreationOrderComparator() {
        }

        @Override
        public int compare(ExpressionView viewA, ExpressionView viewB) {
            if (viewA.getCreationOrder() < viewB.getCreationOrder()) {
                return -1;
            }
            if (viewA.getCreationOrder() > viewB.getCreationOrder()) {
                return 1;
            }
            return 0;
        }
    }
}

