/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.statistics;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class StatisticsIndexMap
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Map<String, DoubleIndex> m_doubleMap = new HashMap<String, DoubleIndex>();
    private final Map<String, LongIndex> m_longMap = new HashMap<String, LongIndex>();
    private final Map<String, LongIndex> m_transientLongMap = new HashMap<String, LongIndex>();
    private final Map<String, DoubleSampleIndex> m_doubleSampleMap = new HashMap<String, DoubleSampleIndex>();
    private final Map<String, LongSampleIndex> m_longSampleMap = new HashMap<String, LongSampleIndex>();
    private final int m_numberOfDoubles;
    private final int m_numberOfLongs;
    public static final String HTTP_PLUGIN_RESPONSE_STATUS_KEY = "httpplugin.responseStatus";
    public static final String HTTP_PLUGIN_RESPONSE_LENGTH_KEY = "httpplugin.responseLength";
    public static final String HTTP_PLUGIN_RESPONSE_ERRORS_KEY = "httpplugin.responseErrors";
    public static final String HTTP_PLUGIN_DNS_TIME_KEY = "httpplugin.dnsTime";
    public static final String HTTP_PLUGIN_CONNECT_TIME_KEY = "httpplugin.connectTime";
    public static final String HTTP_PLUGIN_FIRST_BYTE_TIME_KEY = "httpplugin.firstByteTime";
    public static final String HTTP_PLUGIN_CONNECTIONS_ESTABLISHED = "httpplugin.connectionsEstablished";

    StatisticsIndexMap() {
        this(Arrays.asList("errors", "untimedTests", HTTP_PLUGIN_RESPONSE_STATUS_KEY, HTTP_PLUGIN_RESPONSE_LENGTH_KEY, HTTP_PLUGIN_RESPONSE_ERRORS_KEY, HTTP_PLUGIN_DNS_TIME_KEY, HTTP_PLUGIN_CONNECT_TIME_KEY, HTTP_PLUGIN_FIRST_BYTE_TIME_KEY, HTTP_PLUGIN_CONNECTIONS_ESTABLISHED, "userLong0", "userLong1", "userLong2", "userLong3", "userLong4"), Arrays.asList("peakTPS", "userDouble0", "userDouble1", "userDouble2", "userDouble3", "userDouble4"), Arrays.asList("period"), Arrays.asList("timedTests"));
    }

    StatisticsIndexMap(List<String> longNames, List<String> doubleNames, List<String> transientLongNames, List<String> longSampleNames) {
        int nextLongIndex = 0;
        int nextTransientLongIndex = 0;
        for (String longName : longNames) {
            this.m_longMap.put(longName, new LongIndex(nextLongIndex++));
        }
        int nextDoubleIndex = 0;
        for (String doubleName : doubleNames) {
            this.m_doubleMap.put(doubleName, new DoubleIndex(nextDoubleIndex++));
        }
        for (String longSampleName : longSampleNames) {
            this.createLongSampleIndex(longSampleName, new LongIndex(nextLongIndex++), new LongIndex(nextLongIndex++), new DoubleIndex(nextDoubleIndex++));
        }
        for (String transientLongName : transientLongNames) {
            this.m_transientLongMap.put(transientLongName, new LongIndex(nextTransientLongIndex++, true));
        }
        this.m_numberOfDoubles = nextDoubleIndex;
        this.m_numberOfLongs = nextLongIndex;
    }

    int getNumberOfDoubles() {
        return this.m_numberOfDoubles;
    }

    int getNumberOfLongs() {
        return this.m_numberOfLongs;
    }

    int getNumberOfTransientLongs() {
        return this.m_transientLongMap.size();
    }

    Collection<DoubleSampleIndex> getDoubleSampleIndicies() {
        return this.m_doubleSampleMap.values();
    }

    Collection<LongSampleIndex> getLongSampleIndicies() {
        return this.m_longSampleMap.values();
    }

    public DoubleIndex getDoubleIndex(String statisticName) {
        return this.m_doubleMap.get(statisticName);
    }

    public LongIndex getLongIndex(String statisticName) {
        LongIndex nonTransient = this.m_longMap.get(statisticName);
        if (nonTransient != null) {
            return nonTransient;
        }
        return this.m_transientLongMap.get(statisticName);
    }

    public DoubleSampleIndex getDoubleSampleIndex(String statisticName) {
        return this.m_doubleSampleMap.get(statisticName);
    }

    public LongSampleIndex getLongSampleIndex(String statisticName) {
        return this.m_longSampleMap.get(statisticName);
    }

    private LongSampleIndex createLongSampleIndex(String statisticName, LongIndex sumIndex, LongIndex countIndex, DoubleIndex varianceIndex) {
        LongSampleIndex result = new LongSampleIndex(sumIndex, countIndex, varianceIndex);
        this.m_longSampleMap.put(statisticName, result);
        return result;
    }

    DoubleSampleIndex createDoubleSampleIndex(String statisticName, DoubleIndex sumIndex, LongIndex countIndex, DoubleIndex varianceIndex) {
        DoubleSampleIndex result = new DoubleSampleIndex(sumIndex, countIndex, varianceIndex);
        this.m_doubleSampleMap.put(statisticName, result);
        return result;
    }

    void removeDoubleSampleIndex(String statisticName) {
        this.m_doubleSampleMap.remove(statisticName);
    }

    public static final class LongSampleIndex
    extends SampleIndex {
        private final LongIndex m_sumIndex;

        private LongSampleIndex(LongIndex sumIndex, LongIndex countIndex, DoubleIndex varianceIndex) {
            super(countIndex, varianceIndex);
            this.m_sumIndex = sumIndex;
        }

        LongIndex getSumIndex() {
            return this.m_sumIndex;
        }
    }

    public static final class DoubleSampleIndex
    extends SampleIndex {
        private final DoubleIndex m_sumIndex;

        private DoubleSampleIndex(DoubleIndex sumIndex, LongIndex countIndex, DoubleIndex varianceIndex) {
            super(countIndex, varianceIndex);
            this.m_sumIndex = sumIndex;
        }

        DoubleIndex getSumIndex() {
            return this.m_sumIndex;
        }
    }

    static class SampleIndex {
        private final LongIndex m_countIndex;
        private final DoubleIndex m_varianceIndex;

        protected SampleIndex(LongIndex countIndex, DoubleIndex varianceIndex) {
            this.m_countIndex = countIndex;
            this.m_varianceIndex = varianceIndex;
        }

        final LongIndex getCountIndex() {
            return this.m_countIndex;
        }

        final DoubleIndex getVarianceIndex() {
            return this.m_varianceIndex;
        }
    }

    public static final class LongIndex
    extends AbstractSimpleIndex {
        private LongIndex(int i) {
            this(i, false);
        }

        private LongIndex(int i, boolean isTransient) {
            super(i, isTransient);
        }
    }

    public static final class DoubleIndex
    extends AbstractSimpleIndex {
        private DoubleIndex(int i) {
            super(i, false);
        }
    }

    static abstract class AbstractSimpleIndex {
        private final int m_value;
        private final boolean m_transient;

        protected AbstractSimpleIndex(int i, boolean isTransient) {
            this.m_value = i;
            this.m_transient = isTransient;
        }

        public final int getValue() {
            return this.m_value;
        }

        public boolean isTransient() {
            return this.m_transient;
        }
    }
}

