/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.scriptengine.java;

import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import net.grinder.script.NonInstrumentableTypeException;
import net.grinder.script.Test;
import net.grinder.scriptengine.AbstractDCRInstrumenter;
import net.grinder.scriptengine.DCRContext;
import net.grinder.scriptengine.Recorder;
import net.grinder.util.weave.Weaver;

final class JavaDCRInstrumenter
extends AbstractDCRInstrumenter {
    public JavaDCRInstrumenter(DCRContext context) {
        super(context);
    }

    @Override
    public String getDescription() {
        return "byte code transforming instrumenter for Java";
    }

    @Override
    protected boolean instrument(Object target, Recorder recorder, Test.InstrumentationFilter filter) throws NonInstrumentableTypeException {
        if (target instanceof Class) {
            this.instrumentClass((Class)target, recorder, filter);
        } else if (target != null) {
            this.instrumentInstance(target, recorder, filter);
        }
        return true;
    }

    private void instrumentClass(Class<?> targetClass, Recorder recorder, Test.InstrumentationFilter filter) throws NonInstrumentableTypeException {
        if (targetClass.isArray()) {
            throw new NonInstrumentableTypeException("Can't instrument arrays");
        }
        for (Constructor<?> constructor : targetClass.getDeclaredConstructors()) {
            this.getContext().add(targetClass, constructor, recorder);
        }
        for (Executable executable : targetClass.getDeclaredMethods()) {
            if (!Modifier.isStatic(((Method)executable).getModifiers()) || !filter.matches(executable)) continue;
            this.getContext().add(targetClass, (Method)executable, Weaver.TargetSource.CLASS, recorder);
        }
    }

    private void instrumentInstance(Object target, Recorder recorder, Test.InstrumentationFilter filter) throws NonInstrumentableTypeException {
        Class<?> c = target.getClass();
        if (c.isArray()) {
            throw new NonInstrumentableTypeException("Can't instrument arrays");
        }
        do {
            for (Method method : c.getDeclaredMethods()) {
                if (Modifier.isStatic(method.getModifiers()) || !filter.matches(method)) continue;
                this.getContext().add(target, method, Weaver.TargetSource.FIRST_PARAMETER, recorder);
            }
            c = c.getSuperclass();
        } while (this.getContext().isInstrumentable(c));
    }
}

