/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.scriptengine.clojure;

import java.util.Collections;
import java.util.List;
import net.grinder.engine.common.EngineException;
import net.grinder.engine.common.ScriptLocation;
import net.grinder.scriptengine.Instrumenter;
import net.grinder.scriptengine.ScriptEngineService;
import net.grinder.scriptengine.clojure.ClojureScriptEngine;
import net.grinder.util.FileExtensionMatcher;

public class ClojureScriptEngineService
implements ScriptEngineService {
    private final FileExtensionMatcher m_cljFileMatcher = new FileExtensionMatcher(".clj");

    @Override
    public ScriptEngineService.ScriptEngine createScriptEngine(ScriptLocation script) throws EngineException {
        if (this.m_cljFileMatcher.accept(script.getFile())) {
            try {
                return new ClojureScriptEngine(script);
            }
            catch (LinkageError e) {
                throw new EngineException("Clojure is not on the classpath", e);
            }
        }
        return null;
    }

    @Override
    public List<? extends Instrumenter> createInstrumenters() throws EngineException {
        return Collections.emptyList();
    }
}

