/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.scriptengine.clojure;

import clojure.lang.Compiler;
import java.io.Reader;
import java.io.StringReader;
import java.util.concurrent.Callable;
import net.grinder.engine.common.EngineException;
import net.grinder.engine.common.ScriptLocation;
import net.grinder.scriptengine.ScriptEngineService;
import net.grinder.scriptengine.ScriptExecutionException;

class ClojureScriptEngine
implements ScriptEngineService.ScriptEngine {
    private final Callable<?> m_runnerFactory;

    private static String describeResult(Object r) {
        return r == null ? "nil" : r.getClass().getName();
    }

    public ClojureScriptEngine(ScriptLocation script) throws EngineException {
        Object result;
        try {
            result = Compiler.loadFile((String)script.getFile().getPath());
        }
        catch (Exception e) {
            throw new ClojureScriptExecutionException("Failed to load " + script, e);
        }
        if (!(result instanceof Callable)) {
            throw new ClojureScriptExecutionException("The script should return a function that creates a test runner function [It returned " + ClojureScriptEngine.describeResult(result) + "]");
        }
        this.m_runnerFactory = (Callable)result;
    }

    @Override
    public ScriptEngineService.WorkerRunnable createWorkerRunnable() throws EngineException {
        Object result;
        try {
            result = this.m_runnerFactory.call();
        }
        catch (Exception e) {
            throw new ClojureScriptExecutionException("Failed to create test runner function", e);
        }
        if (!(result instanceof Callable)) {
            throw new ClojureScriptExecutionException("The script should return a function that creates a test runner function [It returned " + ClojureScriptEngine.describeResult(result) + "]");
        }
        return new ClojureWorkerRunnable((Callable)result);
    }

    @Override
    public ScriptEngineService.WorkerRunnable createWorkerRunnable(Object testRunner) throws EngineException {
        if (testRunner instanceof Callable) {
            return new ClojureWorkerRunnable((Callable)testRunner);
        }
        throw new ClojureScriptExecutionException("supplied testRunner is not a function");
    }

    @Override
    public String getDescription() {
        String versionString = "(let [v *clojure-version*] (format \"Clojure %s.%s.%s\" (v :major) (v :minor) (v :incremental)))";
        return Compiler.load((Reader)new StringReader("(let [v *clojure-version*] (format \"Clojure %s.%s.%s\" (v :major) (v :minor) (v :incremental)))")).toString();
    }

    @Override
    public void shutdown() throws EngineException {
    }

    private static final class ClojureScriptExecutionException
    extends ScriptExecutionException {
        public ClojureScriptExecutionException(String s) {
            super(s);
        }

        public ClojureScriptExecutionException(String s, Throwable t) {
            super(s, t);
        }
    }

    private static final class ClojureWorkerRunnable
    implements ScriptEngineService.WorkerRunnable {
        private final Callable<?> m_workerFn;

        private ClojureWorkerRunnable(Callable<?> result) {
            this.m_workerFn = result;
        }

        @Override
        public void run() throws ScriptExecutionException {
            try {
                this.m_workerFn.call();
            }
            catch (Exception e) {
                throw new ClojureScriptExecutionException("Worker thread raised exception", e);
            }
        }

        @Override
        public void shutdown() throws ScriptExecutionException {
        }
    }
}

