/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.scriptengine;

import java.util.Arrays;
import java.util.List;
import net.grinder.common.Test;
import net.grinder.script.NonInstrumentableTypeException;
import net.grinder.script.NotWrappableTypeException;
import net.grinder.script.Test;
import net.grinder.scriptengine.Instrumenter;
import net.grinder.scriptengine.Recorder;

public class CompositeInstrumenter
implements Instrumenter {
    private final List<Instrumenter> m_instrumenters;

    public CompositeInstrumenter(Instrumenter ... instrumenters) {
        this(Arrays.asList(instrumenters));
    }

    public CompositeInstrumenter(List<Instrumenter> instrumenters) {
        this.m_instrumenters = instrumenters;
    }

    @Override
    public Object createInstrumentedProxy(Test test, Recorder recorder, Object target) throws NotWrappableTypeException {
        for (Instrumenter instrumenter : this.m_instrumenters) {
            Object result = instrumenter.createInstrumentedProxy(test, recorder, target);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public boolean instrument(Test test, Recorder recorder, Object target) throws NonInstrumentableTypeException {
        return this.instrument(test, recorder, target, ALL_INSTRUMENTATION);
    }

    @Override
    public boolean instrument(Test test, Recorder recorder, Object target, Test.InstrumentationFilter filter) throws NonInstrumentableTypeException {
        for (Instrumenter instrumenter : this.m_instrumenters) {
            if (!instrumenter.instrument(test, recorder, target, filter)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getDescription() {
        StringBuilder result = new StringBuilder();
        for (Instrumenter instrumenter : this.m_instrumenters) {
            String description = instrumenter.getDescription();
            if (description == null) continue;
            if (result.length() > 0) {
                result.append("; ");
            }
            result.append(description);
        }
        return result.toString();
    }
}

