/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.scriptengine;

import net.grinder.common.Test;
import net.grinder.script.NonInstrumentableTypeException;
import net.grinder.script.NotWrappableTypeException;
import net.grinder.script.Test;
import net.grinder.scriptengine.DCRContext;
import net.grinder.scriptengine.Instrumenter;
import net.grinder.scriptengine.Recorder;
import net.grinder.util.weave.WeavingException;

public abstract class AbstractDCRInstrumenter
implements Instrumenter {
    private final DCRContext m_context;

    protected AbstractDCRInstrumenter(DCRContext context) {
        this.m_context = context;
    }

    protected final DCRContext getContext() {
        return this.m_context;
    }

    @Override
    public final Object createInstrumentedProxy(Test test, Recorder recorder, Object target) throws NotWrappableTypeException {
        try {
            return this.instrument(test, recorder, target) ? target : null;
        }
        catch (NonInstrumentableTypeException e) {
            throw new NotWrappableTypeException(e.getMessage(), e);
        }
    }

    @Override
    public boolean instrument(Test test, Recorder recorder, Object target) throws NonInstrumentableTypeException {
        return this.instrument(test, recorder, target, ALL_INSTRUMENTATION);
    }

    @Override
    public final boolean instrument(Test test, Recorder recorder, Object target, Test.InstrumentationFilter filter) throws NonInstrumentableTypeException {
        boolean changed = this.instrument(target, recorder, filter);
        if (changed) {
            try {
                this.m_context.applyChanges();
            }
            catch (WeavingException e) {
                throw new NonInstrumentableTypeException(e.getMessage());
            }
        }
        return changed;
    }

    protected abstract boolean instrument(Object var1, Recorder var2, Test.InstrumentationFilter var3) throws NonInstrumentableTypeException;
}

