/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.messages.console;

import net.grinder.common.processidentity.ProcessReport;
import net.grinder.common.processidentity.WorkerIdentity;
import net.grinder.common.processidentity.WorkerProcessReport;
import net.grinder.communication.Address;
import net.grinder.communication.AddressAwareMessage;
import net.grinder.communication.CommunicationException;
import net.grinder.messages.console.WorkerAddress;

public final class WorkerProcessReportMessage
implements AddressAwareMessage,
WorkerProcessReport {
    private static final long serialVersionUID = 3L;
    private final ProcessReport.State m_state;
    private final short m_totalNumberOfThreads;
    private final short m_numberOfRunningThreads;
    private transient WorkerAddress m_processAddress;

    public WorkerProcessReportMessage(ProcessReport.State finished, short runningThreads, short totalThreads) {
        this.m_state = finished;
        this.m_numberOfRunningThreads = runningThreads;
        this.m_totalNumberOfThreads = totalThreads;
    }

    @Override
    public void setAddress(Address address) throws CommunicationException {
        try {
            this.m_processAddress = (WorkerAddress)address;
        }
        catch (ClassCastException e) {
            throw new CommunicationException("Not a worker process address", e);
        }
    }

    public WorkerAddress getProcessAddress() {
        return this.m_processAddress;
    }

    @Override
    public WorkerIdentity getWorkerIdentity() {
        return (WorkerIdentity)this.m_processAddress.getIdentity();
    }

    @Override
    public ProcessReport.State getState() {
        return this.m_state;
    }

    @Override
    public short getNumberOfRunningThreads() {
        return this.m_numberOfRunningThreads;
    }

    @Override
    public short getMaximumNumberOfThreads() {
        return this.m_totalNumberOfThreads;
    }
}

