/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.engine.process.dcr;

import extra166y.CustomConcurrentHashMap;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import net.grinder.common.UncheckedGrinderException;
import net.grinder.engine.common.EngineException;
import net.grinder.engine.process.dcr.RecorderRegistry;
import net.grinder.scriptengine.Recorder;

public final class RecorderLocator
implements RecorderRegistry {
    private static final RecorderLocator s_instance = new RecorderLocator();
    private final ConcurrentMap<Object, ConcurrentMap<String, List<Recorder>>> m_recorders = new CustomConcurrentHashMap<Object, Object>(CustomConcurrentHashMap.WEAK, CustomConcurrentHashMap.IDENTITY, CustomConcurrentHashMap.STRONG, CustomConcurrentHashMap.IDENTITY, 101);

    static void clearRecorders() {
        RecorderLocator.s_instance.m_recorders.clear();
    }

    private List<Recorder> getRecorderList(Object target, String locationID) {
        List list;
        ConcurrentMap locationMap = (ConcurrentMap)this.m_recorders.get(target);
        if (locationMap != null && (list = (List)locationMap.get(locationID)) != null) {
            return list;
        }
        return Collections.emptyList();
    }

    public static void enter(Object target, String location) {
        if (target == null) {
            return;
        }
        try {
            for (Recorder recorder : s_instance.getRecorderList(target, location)) {
                recorder.start();
            }
        }
        catch (EngineException e) {
            throw new RecordingFailureException(e);
        }
    }

    public static void exit(Object target, String location, boolean success) {
        if (target == null) {
            return;
        }
        List<Recorder> recorders = s_instance.getRecorderList(target, location);
        ListIterator<Recorder> i = recorders.listIterator(recorders.size());
        try {
            while (i.hasPrevious()) {
                Recorder recorder = i.previous();
                recorder.end(success);
            }
        }
        catch (EngineException e) {
            throw new RecordingFailureException(e);
        }
    }

    static RecorderRegistry getRecorderRegistry() {
        return s_instance;
    }

    @Override
    public void register(Object target, String location, Recorder recorder) {
        CustomConcurrentHashMap<Object, Object> newMap = new CustomConcurrentHashMap<Object, Object>(CustomConcurrentHashMap.STRONG, CustomConcurrentHashMap.IDENTITY, CustomConcurrentHashMap.STRONG, CustomConcurrentHashMap.IDENTITY, 0);
        CustomConcurrentHashMap<Object, Object> oldMap = this.m_recorders.putIfAbsent(target, newMap);
        CustomConcurrentHashMap<Object, Object> locationMap = oldMap != null ? oldMap : newMap;
        CopyOnWriteArrayList<Recorder> newList = new CopyOnWriteArrayList<Recorder>();
        CopyOnWriteArrayList<Recorder> oldList = locationMap.putIfAbsent(location.intern(), newList);
        CopyOnWriteArrayList<Recorder> recorderList = oldList != null ? oldList : newList;
        for (Recorder existingRecorder : recorderList) {
            if (existingRecorder != recorder) continue;
            return;
        }
        recorderList.add(recorder);
    }

    private static final class RecordingFailureException
    extends UncheckedGrinderException {
        private RecordingFailureException(EngineException cause) {
            super("Recording Failure", cause);
        }
    }
}

