/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.engine.process;

import java.io.InputStream;
import net.grinder.communication.StreamReceiver;
import net.grinder.engine.process.GrinderProcess;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkerProcessEntryPoint {
    public static void main(String[] args) {
        if (args.length > 1) {
            System.err.println("Usage: java " + GrinderProcess.class.getName());
            System.exit(-1);
        }
        int exitCode = new WorkerProcessEntryPoint().run(System.in);
        System.exit(exitCode);
    }

    /*
     * Loose catch block
     */
    public int run(InputStream agentCommunicationStream) {
        GrinderProcess grinderProcess;
        Logger logger = LoggerFactory.getLogger((String)"worker-bootstrap");
        try {
            grinderProcess = new GrinderProcess(new StreamReceiver(agentCommunicationStream));
        }
        catch (Exception e) {
            logger.error("Error initialising worker process", (Throwable)e);
            return -2;
        }
        try {
            grinderProcess.run();
            int e = 0;
            grinderProcess.shutdown(agentCommunicationStream == System.in);
            return e;
        }
        catch (Exception e) {
            logger.error("Error running worker process", (Throwable)e);
            int n = -3;
            grinderProcess.shutdown(agentCommunicationStream == System.in);
            return n;
        }
        catch (Error t) {
            logger.error("Error running worker process", (Throwable)t);
            throw t;
            {
                catch (Throwable throwable) {
                    grinderProcess.shutdown(agentCommunicationStream == System.in);
                    throw throwable;
                }
            }
        }
    }
}

