/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.engine.process;

import net.grinder.common.Test;
import net.grinder.common.UncheckedGrinderException;
import net.grinder.engine.common.EngineException;
import net.grinder.engine.process.DispatchContext;
import net.grinder.engine.process.DispatchResultReporter;
import net.grinder.engine.process.StatisticsForTestImplementation;
import net.grinder.engine.process.StopWatch;
import net.grinder.engine.process.StopWatchImplementation;
import net.grinder.engine.process.TestStatisticsHelper;
import net.grinder.engine.process.ThreadContext;
import net.grinder.engine.process.ThreadContextLocator;
import net.grinder.script.NonInstrumentableTypeException;
import net.grinder.script.NotWrappableTypeException;
import net.grinder.script.Statistics;
import net.grinder.script.Test;
import net.grinder.script.TestRegistry;
import net.grinder.scriptengine.Instrumenter;
import net.grinder.scriptengine.Recorder;
import net.grinder.statistics.StatisticsSet;
import net.grinder.statistics.StatisticsSetFactory;
import net.grinder.util.TimeAuthority;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

final class TestData
implements TestRegistry.RegisteredTest,
Recorder {
    private final StatisticsSetFactory m_statisticsSetFactory;
    private final TestStatisticsHelper m_testStatisticsHelper;
    private final TimeAuthority m_timeAuthority;
    private final Instrumenter m_instrumenter;
    private final ThreadContextLocator m_threadContextLocator;
    private final Test m_test;
    private final Marker m_logMarker;
    private final StatisticsSet m_testStatistics;
    private final RecorderHolderThreadLocal m_recorderHolderTL = new RecorderHolderThreadLocal();

    TestData(ThreadContextLocator threadContextLocator, StatisticsSetFactory statisticsSetFactory, TestStatisticsHelper testStatisticsHelper, TimeAuthority timeAuthority, Instrumenter instrumenter, Test testDefinition) {
        this.m_statisticsSetFactory = statisticsSetFactory;
        this.m_testStatisticsHelper = testStatisticsHelper;
        this.m_timeAuthority = timeAuthority;
        this.m_instrumenter = instrumenter;
        this.m_threadContextLocator = threadContextLocator;
        this.m_test = testDefinition;
        this.m_testStatistics = this.m_statisticsSetFactory.create();
        this.m_logMarker = MarkerFactory.getMarker((String)("test-" + testDefinition.getNumber()));
    }

    Test getTest() {
        return this.m_test;
    }

    Marker getLogMarker() {
        return this.m_logMarker;
    }

    StatisticsSet getTestStatistics() {
        return this.m_testStatistics;
    }

    @Override
    public Object createProxy(Object o) throws NotWrappableTypeException {
        return this.m_instrumenter.createInstrumentedProxy(this.getTest(), this, o);
    }

    @Override
    public void instrument(Object target) throws NonInstrumentableTypeException {
        this.m_instrumenter.instrument(this.getTest(), this, target);
    }

    @Override
    public void instrument(Object target, Test.InstrumentationFilter filter) throws NonInstrumentableTypeException {
        this.m_instrumenter.instrument(this.getTest(), this, target, filter);
    }

    @Override
    public void start() throws EngineException {
        this.m_recorderHolderTL.getHolder().start();
    }

    @Override
    public void end(boolean success) throws EngineException {
        this.m_recorderHolderTL.getHolder().end(success);
    }

    private static final class UncheckedException
    extends UncheckedGrinderException {
        public UncheckedException(String message) {
            super(message);
        }
    }

    private final class TestRecorder
    implements DispatchContext,
    Recorder {
        private final DispatchResultReporter m_resultReporter;
        private final StopWatch m_pauseTimer;
        private long m_startTime = -1L;
        private long m_dispatchTime = -1L;
        private StatisticsForTestImplementation m_statisticsForTest;

        public TestRecorder(DispatchResultReporter resultReporter, StopWatch pauseTimer) {
            this.m_resultReporter = resultReporter;
            this.m_pauseTimer = pauseTimer;
        }

        @Override
        public void start() throws DispatchContext.DispatchStateException {
            if (this.m_startTime != -1L || this.m_dispatchTime != -1L) {
                throw new DispatchContext.DispatchStateException("Last statistics were not reported");
            }
            this.m_pauseTimer.reset();
            this.m_statisticsForTest = new StatisticsForTestImplementation(this, TestData.this.m_testStatisticsHelper, TestData.this.m_statisticsSetFactory.create());
            Thread.yield();
            this.m_startTime = TestData.this.m_timeAuthority.getTimeInMilliseconds();
        }

        @Override
        public void end(boolean success) {
            this.m_dispatchTime = Math.max(TestData.this.m_timeAuthority.getTimeInMilliseconds() - this.m_startTime, 0L);
            if (this.m_pauseTimer.isRunning()) {
                this.m_pauseTimer.stop();
            }
            if (!success && this.m_statisticsForTest != null) {
                TestData.this.m_testStatisticsHelper.setSuccess(this.m_statisticsForTest.getStatistics(), false);
            }
        }

        @Override
        public void report() throws DispatchContext.DispatchStateException {
            if (this.m_dispatchTime < 0L) {
                throw new DispatchContext.DispatchStateException("No statistics to report");
            }
            StatisticsSet statistics = this.m_statisticsForTest.getStatistics();
            TestData.this.m_testStatisticsHelper.recordTest(statistics, this.getElapsedTime());
            this.m_resultReporter.report(this.getTest(), this.m_startTime, statistics);
            if (TestData.this.m_testStatisticsHelper.getSuccess(statistics)) {
                TestData.this.getTestStatistics().add(statistics);
            } else {
                TestData.this.m_testStatisticsHelper.incrementErrors(TestData.this.getTestStatistics());
            }
            this.m_statisticsForTest.freeze();
            this.m_statisticsForTest = null;
            this.m_startTime = -1L;
            this.m_dispatchTime = -1L;
        }

        @Override
        public Test getTest() {
            return TestData.this.getTest();
        }

        @Override
        public Marker getLogMarker() {
            return TestData.this.getLogMarker();
        }

        @Override
        public StopWatch getPauseTimer() {
            return this.m_pauseTimer;
        }

        @Override
        public long getElapsedTime() {
            if (this.m_startTime == -1L) {
                return -1L;
            }
            long unadjustedTime = this.m_dispatchTime == -1L ? TestData.this.m_timeAuthority.getTimeInMilliseconds() - this.m_startTime : this.m_dispatchTime;
            return Math.max(unadjustedTime - this.m_pauseTimer.getTime(), 0L);
        }

        @Override
        public Statistics.StatisticsForTest getStatisticsForTest() {
            return this.m_statisticsForTest;
        }

        @Override
        public void setHasNestedContexts() {
            TestData.this.m_testStatistics.setIsComposite();
        }
    }

    private static final class RecorderHolder
    implements Recorder {
        private final ThreadContext m_threadContext;
        private final TestRecorder m_recorder;
        private int m_nestingDepth = 0;

        public RecorderHolder(ThreadContext threadContext, TestRecorder recorder) {
            this.m_threadContext = threadContext;
            this.m_recorder = recorder;
        }

        @Override
        public void start() throws DispatchContext.DispatchStateException {
            if (this.m_nestingDepth++ == 0) {
                this.m_threadContext.pushDispatchContext(this.m_recorder);
                this.m_recorder.start();
            }
        }

        @Override
        public void end(boolean success) {
            if (--this.m_nestingDepth == 0) {
                this.m_recorder.end(success);
                this.m_threadContext.popDispatchContext();
            }
        }
    }

    private final class RecorderHolderThreadLocal {
        private final ThreadLocal<RecorderHolder> m_threadLocal = new ThreadLocal<RecorderHolder>(){

            @Override
            public RecorderHolder initialValue() {
                ThreadContext threadContext = TestData.this.m_threadContextLocator.get();
                if (threadContext == null) {
                    throw new UncheckedException("Only Worker Threads can invoke tests");
                }
                TestRecorder recorder = new TestRecorder(threadContext.getDispatchResultReporter(), new StopWatchImplementation(TestData.this.m_timeAuthority));
                return new RecorderHolder(threadContext, recorder);
            }
        };

        private RecorderHolderThreadLocal() {
        }

        public RecorderHolder getHolder() throws EngineException {
            try {
                return this.m_threadLocal.get();
            }
            catch (UncheckedException e) {
                throw new EngineException(e.getMessage());
            }
        }
    }
}

