/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.engine.process;

import java.util.ArrayList;
import net.grinder.common.GrinderProperties;
import net.grinder.engine.common.EngineException;
import net.grinder.engine.common.ScriptLocation;
import net.grinder.engine.process.MasterInstrumenter;
import net.grinder.scriptengine.DCRContext;
import net.grinder.scriptengine.Instrumenter;
import net.grinder.scriptengine.ScriptEngineService;
import net.grinder.util.ClassLoaderUtilities;
import org.picocontainer.ComponentFactory;
import org.picocontainer.DefaultPicoContainer;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.behaviors.Caching;
import org.slf4j.Logger;

final class ScriptEngineContainer {
    private final MutablePicoContainer m_container = new DefaultPicoContainer((ComponentFactory)new Caching());

    public ScriptEngineContainer(GrinderProperties properties, Logger logger, DCRContext dcrContext, ScriptLocation scriptLocation) throws EngineException {
        this.m_container.addComponent((Object)properties);
        this.m_container.addComponent((Object)logger);
        this.m_container.addComponent((Object)scriptLocation);
        if (dcrContext != null) {
            this.m_container.addComponent((Object)dcrContext);
        }
        for (Class<ScriptEngineService> implementation : ClassLoaderUtilities.loadRegisteredImplementations("META-INF/net.grinder.scriptengine", ScriptEngineService.class)) {
            this.m_container.addComponent(implementation);
        }
    }

    public ScriptEngineService.ScriptEngine getScriptEngine(ScriptLocation script) throws EngineException {
        for (ScriptEngineService service : this.m_container.getComponents(ScriptEngineService.class)) {
            ScriptEngineService.ScriptEngine engine = service.createScriptEngine(script);
            if (engine == null) continue;
            return engine;
        }
        throw new EngineException("No suitable script engine installed for '" + script + "'");
    }

    public Instrumenter createInstrumenter() throws EngineException {
        ArrayList<Instrumenter> instrumenters = new ArrayList<Instrumenter>();
        for (ScriptEngineService service : this.m_container.getComponents(ScriptEngineService.class)) {
            for (Instrumenter instrumenter : service.createInstrumenters()) {
                instrumenters.add(instrumenter);
            }
        }
        return new MasterInstrumenter(instrumenters);
    }
}

