/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.engine.process;

import net.grinder.engine.common.EngineException;
import net.grinder.engine.process.ThreadContext;
import net.grinder.engine.process.ThreadContextLocator;
import net.grinder.plugininterface.GrinderPlugin;
import net.grinder.plugininterface.PluginException;
import net.grinder.plugininterface.PluginProcessContext;
import net.grinder.plugininterface.PluginThreadListener;
import net.grinder.script.Grinder;
import net.grinder.statistics.StatisticsServices;
import net.grinder.util.TimeAuthority;
import org.slf4j.Logger;

final class RegisteredPlugin
implements PluginProcessContext {
    private final GrinderPlugin m_plugin;
    private final Grinder.ScriptContext m_scriptContext;
    private final ThreadContextLocator m_threadContextLocator;
    private final StatisticsServices m_statisticsServices;
    private final ThreadLocal<PluginThreadListener> m_threadListenerThreadLocal = new ThreadLocal();
    private final TimeAuthority m_timeAuthority;
    private final Logger m_logger;

    public RegisteredPlugin(GrinderPlugin plugin, Grinder.ScriptContext scriptContext, ThreadContextLocator threadContextLocator, StatisticsServices statisticsServices, TimeAuthority timeAuthority, Logger logger) {
        this.m_plugin = plugin;
        this.m_scriptContext = scriptContext;
        this.m_threadContextLocator = threadContextLocator;
        this.m_statisticsServices = statisticsServices;
        this.m_timeAuthority = timeAuthority;
        this.m_logger = logger;
    }

    @Override
    public Grinder.ScriptContext getScriptContext() {
        return this.m_scriptContext;
    }

    @Override
    public PluginThreadListener getPluginThreadListener() throws EngineException {
        ThreadContext threadContext = this.m_threadContextLocator.get();
        if (threadContext == null) {
            throw new EngineException("Must be called from worker thread");
        }
        return this.createPluginThreadListener(threadContext);
    }

    PluginThreadListener createPluginThreadListener(ThreadContext threadContext) throws EngineException {
        PluginThreadListener newPluginThreadListener;
        PluginThreadListener existingPluginThreadListener = this.m_threadListenerThreadLocal.get();
        if (existingPluginThreadListener != null) {
            return existingPluginThreadListener;
        }
        try {
            newPluginThreadListener = this.m_plugin.createThreadListener(threadContext);
        }
        catch (PluginException e) {
            this.m_logger.error(threadContext.getLogMarker(), "Plugin could not create thread listener", (Throwable)e);
            throw new EngineException("Plugin could not create thread listener", e);
        }
        this.m_threadListenerThreadLocal.set(newPluginThreadListener);
        threadContext.registerThreadLifeCycleListener(newPluginThreadListener);
        return newPluginThreadListener;
    }

    @Override
    public StatisticsServices getStatisticsServices() {
        return this.m_statisticsServices;
    }

    @Override
    public TimeAuthority getTimeAuthority() {
        return this.m_timeAuthority;
    }
}

