/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.console.synchronisation;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.grinder.common.processidentity.WorkerIdentity;
import net.grinder.common.processidentity.WorkerProcessReport;
import net.grinder.communication.CommunicationException;
import net.grinder.communication.MessageDispatchRegistry;
import net.grinder.console.communication.ConsoleCommunication;
import net.grinder.console.communication.ProcessControl;
import net.grinder.console.synchronisation.ConsoleBarrierGroups;
import net.grinder.console.synchronisation.ProcessBarrierGroups;
import net.grinder.synchronisation.BarrierGroups;
import net.grinder.synchronisation.messages.AddBarrierMessage;
import net.grinder.synchronisation.messages.AddWaiterMessage;
import net.grinder.synchronisation.messages.CancelWaiterMessage;
import net.grinder.synchronisation.messages.RemoveBarriersMessage;

public class WireDistributedBarriers {
    private final Map<WorkerIdentity, ProcessBarrierGroups> m_processBarriers = new HashMap<WorkerIdentity, ProcessBarrierGroups>();
    private final BarrierGroups m_consoleBarrierGroups;

    public WireDistributedBarriers(ConsoleCommunication communication, ProcessControl processControl) {
        this(communication, processControl, new ConsoleBarrierGroups(communication));
    }

    WireDistributedBarriers(ConsoleCommunication communication, ProcessControl processControl, BarrierGroups consoleBarrierGroups) {
        this.m_consoleBarrierGroups = consoleBarrierGroups;
        MessageDispatchRegistry messageDispatch = communication.getMessageDispatchRegistry();
        messageDispatch.set(AddBarrierMessage.class, new MessageDispatchRegistry.AbstractHandler<AddBarrierMessage>(){

            @Override
            public void handle(AddBarrierMessage message) throws CommunicationException {
                WireDistributedBarriers.this.getBarrierGroupsForProcess(message.getProcessIdentity()).getGroup(message.getName()).addBarrier();
            }
        });
        messageDispatch.set(RemoveBarriersMessage.class, new MessageDispatchRegistry.AbstractHandler<RemoveBarriersMessage>(){

            @Override
            public void handle(RemoveBarriersMessage message) throws CommunicationException {
                WireDistributedBarriers.this.getBarrierGroupsForProcess(message.getProcessIdentity()).getGroup(message.getName()).removeBarriers(message.getNumberOfBarriers());
            }
        });
        messageDispatch.set(AddWaiterMessage.class, new MessageDispatchRegistry.AbstractHandler<AddWaiterMessage>(){

            @Override
            public void handle(AddWaiterMessage message) throws CommunicationException {
                WireDistributedBarriers.this.getBarrierGroupsForProcess(message.getProcessIdentity()).getGroup(message.getName()).addWaiter(message.getBarrierIdentity());
            }
        });
        messageDispatch.set(CancelWaiterMessage.class, new MessageDispatchRegistry.AbstractHandler<CancelWaiterMessage>(){

            @Override
            public void handle(CancelWaiterMessage message) throws CommunicationException {
                WireDistributedBarriers.this.getBarrierGroupsForProcess(message.getProcessIdentity()).getGroup(message.getName()).cancelWaiter(message.getBarrierIdentity());
            }
        });
        processControl.addProcessStatusListener(new ProcessControl.Listener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            @Override
            public void update(ProcessControl.ProcessReports[] processReports) {
                void var5_7;
                HashSet<WorkerIdentity> liveWorkers = new HashSet<WorkerIdentity>();
                ProcessControl.ProcessReports[] arr$ = processReports;
                int len$22 = arr$.length;
                boolean bl = false;
                while (var5_7 < len$22) {
                    ProcessControl.ProcessReports agentReport = arr$[var5_7];
                    for (WorkerProcessReport workerReport : agentReport.getWorkerProcessReports()) {
                        liveWorkers.add(workerReport.getWorkerIdentity());
                    }
                    ++var5_7;
                }
                HashSet<Map.Entry> dead = new HashSet<Map.Entry>();
                Map len$22 = WireDistributedBarriers.this.m_processBarriers;
                synchronized (len$22) {
                    for (Map.Entry p : WireDistributedBarriers.this.m_processBarriers.entrySet()) {
                        if (liveWorkers.contains(p.getKey())) continue;
                        dead.add(p);
                    }
                    for (Map.Entry p : dead) {
                        WireDistributedBarriers.this.m_processBarriers.remove(p.getKey());
                    }
                }
                for (Map.Entry entry : dead) {
                    try {
                        ((ProcessBarrierGroups)entry.getValue()).cancelAll();
                    }
                    catch (CommunicationException e) {
                        throw new AssertionError((Object)e);
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BarrierGroups getBarrierGroupsForProcess(WorkerIdentity processIdentity) {
        Map<WorkerIdentity, ProcessBarrierGroups> map = this.m_processBarriers;
        synchronized (map) {
            BarrierGroups existing = this.m_processBarriers.get(processIdentity);
            if (existing != null) {
                return existing;
            }
            ProcessBarrierGroups newState = new ProcessBarrierGroups(this.m_consoleBarrierGroups);
            this.m_processBarriers.put(processIdentity, newState);
            return newState;
        }
    }
}

