/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.console.model;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeSet;
import net.grinder.common.GrinderException;
import net.grinder.common.Test;
import net.grinder.console.common.ErrorHandler;
import net.grinder.console.common.Resources;
import net.grinder.console.model.ConsoleProperties;
import net.grinder.console.model.ModelTestIndex;
import net.grinder.console.model.SampleAccumulator;
import net.grinder.console.model.SampleListener;
import net.grinder.console.model.SampleModel;
import net.grinder.statistics.PeakStatisticExpression;
import net.grinder.statistics.StatisticExpression;
import net.grinder.statistics.StatisticExpressionFactory;
import net.grinder.statistics.StatisticsIndexMap;
import net.grinder.statistics.StatisticsServices;
import net.grinder.statistics.StatisticsSet;
import net.grinder.statistics.TestStatisticsMap;
import net.grinder.util.ListenerSupport;

public final class SampleModelImplementation
implements SampleModel {
    private final ConsoleProperties m_properties;
    private final StatisticsServices m_statisticsServices;
    private final Timer m_timer;
    private final ErrorHandler m_errorHandler;
    private final String m_stateIgnoringString;
    private final String m_stateWaitingString;
    private final String m_stateStoppedString;
    private final String m_stateCapturingString;
    private final String m_unknownTestString;
    private final Set<Test> m_tests = new TreeSet<Test>();
    private final ListenerSupport<SampleModel.Listener> m_listeners = new ListenerSupport();
    private final StatisticsIndexMap.LongIndex m_periodIndex;
    private final StatisticExpression m_tpsExpression;
    private final PeakStatisticExpression m_peakTPSExpression;
    private final SampleAccumulator m_totalSampleAccumulator;
    private final Map<Test, SampleAccumulator> m_accumulators = Collections.synchronizedMap(new HashMap());
    private InternalState m_state;

    public SampleModelImplementation(ConsoleProperties properties, StatisticsServices statisticsServices, Timer timer, Resources resources, ErrorHandler errorHandler) throws GrinderException {
        this.m_properties = properties;
        this.m_statisticsServices = statisticsServices;
        this.m_timer = timer;
        this.m_errorHandler = errorHandler;
        this.m_stateIgnoringString = resources.getString("state.ignoring.label") + ' ';
        this.m_stateWaitingString = resources.getString("state.waiting.label");
        this.m_stateStoppedString = resources.getString("state.stopped.label");
        this.m_stateCapturingString = resources.getString("state.capturing.label") + ' ';
        this.m_unknownTestString = resources.getString("ignoringUnknownTest.text");
        StatisticsIndexMap indexMap = statisticsServices.getStatisticsIndexMap();
        this.m_periodIndex = indexMap.getLongIndex("period");
        StatisticExpressionFactory statisticExpressionFactory = this.m_statisticsServices.getStatisticExpressionFactory();
        this.m_tpsExpression = statisticsServices.getTPSExpression();
        this.m_peakTPSExpression = statisticExpressionFactory.createPeak(indexMap.getDoubleIndex("peakTPS"), this.m_tpsExpression);
        this.m_totalSampleAccumulator = new SampleAccumulator(this.m_peakTPSExpression, this.m_periodIndex, this.m_statisticsServices.getStatisticsSetFactory());
        this.setInternalState(new WaitingForTriggerState());
    }

    @Override
    public StatisticExpression getTPSExpression() {
        return this.m_tpsExpression;
    }

    @Override
    public StatisticExpression getPeakTPSExpression() {
        return this.m_peakTPSExpression;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerTests(Collection<Test> tests) {
        Test[] testArray;
        final HashSet<Test> newTests = new HashSet<Test>(tests);
        Set<Test> set = this.m_tests;
        synchronized (set) {
            newTests.removeAll(this.m_tests);
            if (newTests.size() == 0) {
                return;
            }
            this.m_tests.addAll(newTests);
            testArray = this.m_tests.toArray(new Test[this.m_tests.size()]);
        }
        SampleAccumulator[] accumulatorArray = new SampleAccumulator[testArray.length];
        Map<Test, SampleAccumulator> map = this.m_accumulators;
        synchronized (map) {
            for (Test test : newTests) {
                this.m_accumulators.put(test, new SampleAccumulator(this.m_peakTPSExpression, this.m_periodIndex, this.m_statisticsServices.getStatisticsSetFactory()));
            }
            for (int i = 0; i < accumulatorArray.length; ++i) {
                accumulatorArray[i] = this.m_accumulators.get(testArray[i]);
            }
        }
        final ModelTestIndex modelTestIndex = new ModelTestIndex(testArray, accumulatorArray);
        this.m_listeners.apply(new ListenerSupport.Informer<SampleModel.Listener>(){

            @Override
            public void inform(SampleModel.Listener l) {
                l.newTests(newTests, modelTestIndex);
            }
        });
    }

    @Override
    public StatisticsSet getTotalCumulativeStatistics() {
        return this.m_totalSampleAccumulator.getCumulativeStatistics();
    }

    @Override
    public StatisticsSet getTotalLatestStatistics() {
        return this.m_totalSampleAccumulator.getLastSampleStatistics();
    }

    @Override
    public void addModelListener(SampleModel.Listener listener) {
        this.m_listeners.add(listener);
    }

    @Override
    public void addSampleListener(Test test, SampleListener listener) {
        SampleAccumulator sampleAccumulator = this.m_accumulators.get(test);
        if (sampleAccumulator != null) {
            sampleAccumulator.addSampleListener(listener);
        }
    }

    @Override
    public void addTotalSampleListener(SampleListener listener) {
        this.m_totalSampleAccumulator.addSampleListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        Set<Test> set = this.m_tests;
        synchronized (set) {
            this.m_tests.clear();
        }
        this.m_accumulators.clear();
        this.m_totalSampleAccumulator.zero();
        this.m_listeners.apply(new ListenerSupport.Informer<SampleModel.Listener>(){

            @Override
            public void inform(SampleModel.Listener l) {
                l.resetTests();
            }
        });
    }

    @Override
    public void zeroStatistics() {
        this.zero();
    }

    @Override
    public void start() {
        this.getInternalState().start();
    }

    @Override
    public void stop() {
        this.getInternalState().stop();
    }

    @Override
    public void addTestReport(TestStatisticsMap testStatisticsMap) {
        this.getInternalState().newTestReport(testStatisticsMap);
    }

    @Override
    public SampleModel.State getState() {
        return this.getInternalState().toExternalState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zero() {
        Map<Test, SampleAccumulator> map = this.m_accumulators;
        synchronized (map) {
            for (SampleAccumulator sampleAccumulator : this.m_accumulators.values()) {
                sampleAccumulator.zero();
            }
        }
        this.m_totalSampleAccumulator.zero();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InternalState getInternalState() {
        SampleModelImplementation sampleModelImplementation = this;
        synchronized (sampleModelImplementation) {
            return this.m_state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setInternalState(InternalState newState) {
        SampleModelImplementation sampleModelImplementation = this;
        synchronized (sampleModelImplementation) {
            this.m_state = newState;
        }
        this.m_listeners.apply(new ListenerSupport.Informer<SampleModel.Listener>(){

            @Override
            public void inform(SampleModel.Listener l) {
                l.stateChanged();
            }
        });
    }

    private final class CapturingState
    extends SamplingState {
        public CapturingState() {
            SampleModelImplementation.this.zero();
            this.schedule();
        }

        @Override
        protected boolean shouldAccumulateSamples() {
            return true;
        }

        @Override
        protected InternalState nextState() {
            int collectSampleCount = SampleModelImplementation.this.m_properties.getCollectSampleCount();
            if (collectSampleCount != 0 && this.getSampleCount() > (long)collectSampleCount) {
                return new StoppedState();
            }
            return this;
        }

        @Override
        public String getDescription() {
            return SampleModelImplementation.this.m_stateCapturingString + this.getSampleCount();
        }

        @Override
        public SampleModel.State.Value getValue() {
            return SampleModel.State.Value.Recording;
        }
    }

    private final class TriggeredState
    extends SamplingState {
        public TriggeredState() {
            this.schedule();
        }

        @Override
        protected boolean shouldAccumulateSamples() {
            return false;
        }

        @Override
        protected InternalState nextState() {
            if (this.getSampleCount() > (long)SampleModelImplementation.this.m_properties.getIgnoreSampleCount()) {
                return new CapturingState();
            }
            return this;
        }

        @Override
        public String getDescription() {
            return SampleModelImplementation.this.m_stateIgnoringString + this.getSampleCount();
        }

        @Override
        public SampleModel.State.Value getValue() {
            return SampleModel.State.Value.IgnoringInitialSamples;
        }
    }

    private abstract class SamplingState
    extends AbstractInternalState {
        private long m_lastTime;
        private volatile long m_sampleCount;

        private SamplingState() {
            this.m_lastTime = 0L;
            this.m_sampleCount = 1L;
        }

        @Override
        public final void newTestReport(TestStatisticsMap testStatisticsMap) {
            new TestStatisticsMap.ForEach(testStatisticsMap){

                @Override
                public void next(Test test, StatisticsSet statistics) {
                    SampleAccumulator sampleAccumulator = (SampleAccumulator)SampleModelImplementation.this.m_accumulators.get(test);
                    if (sampleAccumulator == null) {
                        SampleModelImplementation.this.m_errorHandler.handleInformationMessage(SampleModelImplementation.this.m_unknownTestString + " " + test);
                    } else {
                        sampleAccumulator.addIntervalStatistics(statistics);
                        if (SamplingState.this.shouldAccumulateSamples()) {
                            sampleAccumulator.addCumulativeStaticstics(statistics);
                        }
                        if (!statistics.isComposite()) {
                            SampleModelImplementation.this.m_totalSampleAccumulator.addIntervalStatistics(statistics);
                            if (SamplingState.this.shouldAccumulateSamples()) {
                                SampleModelImplementation.this.m_totalSampleAccumulator.addCumulativeStaticstics(statistics);
                            }
                        }
                    }
                }
            }.iterate();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final void schedule() {
            SamplingState samplingState = this;
            synchronized (samplingState) {
                if (this.m_lastTime == 0L) {
                    this.m_lastTime = System.currentTimeMillis();
                }
            }
            SampleModelImplementation.this.m_timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    SamplingState.this.sample();
                }
            }, SampleModelImplementation.this.m_properties.getSampleInterval());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void sample() {
            if (!this.isActiveState()) {
                return;
            }
            try {
                long period;
                SamplingState samplingState = this;
                synchronized (samplingState) {
                    period = System.currentTimeMillis() - this.m_lastTime;
                }
                long sampleInterval = SampleModelImplementation.this.m_properties.getSampleInterval();
                Map map = SampleModelImplementation.this.m_accumulators;
                synchronized (map) {
                    for (SampleAccumulator sampleAccumulator : SampleModelImplementation.this.m_accumulators.values()) {
                        sampleAccumulator.fireSample(sampleInterval, period);
                    }
                }
                SampleModelImplementation.this.m_totalSampleAccumulator.fireSample(sampleInterval, period);
                ++this.m_sampleCount;
                SampleModelImplementation.this.setInternalState(this.nextState());
                SampleModelImplementation.this.m_listeners.apply(new ListenerSupport.Informer<SampleModel.Listener>(){

                    @Override
                    public void inform(SampleModel.Listener l) {
                        l.newSample();
                    }
                });
            }
            finally {
                SamplingState samplingState = this;
                synchronized (samplingState) {
                    if (this.isActiveState()) {
                        this.schedule();
                    }
                }
            }
        }

        @Override
        public final long getSampleCount() {
            return this.m_sampleCount;
        }

        protected abstract boolean shouldAccumulateSamples();

        protected abstract InternalState nextState();
    }

    private final class StoppedState
    extends AbstractInternalState {
        private StoppedState() {
        }

        @Override
        public void newTestReport(TestStatisticsMap testStatisticsMap) {
        }

        @Override
        public String getDescription() {
            return SampleModelImplementation.this.m_stateStoppedString;
        }

        @Override
        public SampleModel.State.Value getValue() {
            return SampleModel.State.Value.Stopped;
        }
    }

    private final class WaitingForTriggerState
    extends AbstractInternalState {
        public WaitingForTriggerState() {
            SampleModelImplementation.this.zero();
        }

        @Override
        public void newTestReport(TestStatisticsMap testStatisticsMap) {
            if (SampleModelImplementation.this.m_properties.getIgnoreSampleCount() == 0) {
                SampleModelImplementation.this.setInternalState(new CapturingState());
            } else {
                SampleModelImplementation.this.setInternalState(new TriggeredState());
            }
            SampleModelImplementation.this.getInternalState().newTestReport(testStatisticsMap);
        }

        @Override
        public String getDescription() {
            return SampleModelImplementation.this.m_stateWaitingString;
        }

        @Override
        public SampleModel.State.Value getValue() {
            return SampleModel.State.Value.WaitingForFirstReport;
        }
    }

    private abstract class AbstractInternalState
    implements InternalState,
    SampleModel.State {
        private AbstractInternalState() {
        }

        protected final boolean isActiveState() {
            return SampleModelImplementation.this.getInternalState() == this;
        }

        @Override
        public final SampleModel.State toExternalState() {
            return this;
        }

        @Override
        public final void start() {
            SampleModelImplementation.this.setInternalState(new WaitingForTriggerState());
        }

        @Override
        public final void stop() {
            SampleModelImplementation.this.setInternalState(new StoppedState());
        }

        @Override
        public long getSampleCount() {
            return -1L;
        }
    }

    private static interface InternalState {
        public SampleModel.State toExternalState();

        public void start();

        public void stop();

        public void newTestReport(TestStatisticsMap var1);
    }
}

