/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.console.model;

import net.grinder.console.model.SampleListener;
import net.grinder.statistics.PeakStatisticExpression;
import net.grinder.statistics.StatisticsIndexMap;
import net.grinder.statistics.StatisticsSet;
import net.grinder.statistics.StatisticsSetFactory;
import net.grinder.util.ListenerSupport;

final class SampleAccumulator {
    private final ListenerSupport<SampleListener> m_listeners = new ListenerSupport();
    private final PeakStatisticExpression m_peakTPSExpression;
    private final StatisticsIndexMap.LongIndex m_periodIndex;
    private final StatisticsSetFactory m_statisticsSetFactory;
    private final StatisticsSet m_cumulativeStatistics;
    private StatisticsSet m_intervalStatistics;
    private StatisticsSet m_lastSampleStatistics;

    public SampleAccumulator(PeakStatisticExpression peakTPSExpression, StatisticsIndexMap.LongIndex periodIndex, StatisticsSetFactory statisticsSetFactory) {
        this.m_peakTPSExpression = peakTPSExpression;
        this.m_periodIndex = periodIndex;
        this.m_statisticsSetFactory = statisticsSetFactory;
        this.m_cumulativeStatistics = this.m_statisticsSetFactory.create();
        this.m_intervalStatistics = this.m_statisticsSetFactory.create();
        this.m_lastSampleStatistics = this.m_statisticsSetFactory.create();
    }

    public void addSampleListener(SampleListener listener) {
        this.m_listeners.add(listener);
    }

    public void addIntervalStatistics(StatisticsSet report) {
        this.m_intervalStatistics.add(report);
    }

    public void addCumulativeStaticstics(StatisticsSet report) {
        this.m_cumulativeStatistics.add(report);
    }

    public void fireSample(long sampleInterval, long period) {
        this.m_intervalStatistics.setValue(this.m_periodIndex, sampleInterval);
        this.m_cumulativeStatistics.setValue(this.m_periodIndex, period);
        this.m_peakTPSExpression.update(this.m_intervalStatistics, this.m_cumulativeStatistics);
        this.m_listeners.apply(new ListenerSupport.Informer<SampleListener>(){

            @Override
            public void inform(SampleListener l) {
                l.update(SampleAccumulator.this.m_intervalStatistics, SampleAccumulator.this.m_cumulativeStatistics);
            }
        });
        this.m_lastSampleStatistics = this.m_intervalStatistics;
        this.m_intervalStatistics = this.m_statisticsSetFactory.create();
    }

    public void zero() {
        this.m_intervalStatistics.reset();
        this.m_lastSampleStatistics.reset();
        this.m_cumulativeStatistics.reset();
    }

    public StatisticsSet getLastSampleStatistics() {
        return this.m_lastSampleStatistics;
    }

    public StatisticsSet getCumulativeStatistics() {
        return this.m_cumulativeStatistics;
    }
}

