/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.console.model;

import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.grinder.common.GrinderProperties;
import net.grinder.console.common.ConsoleException;
import net.grinder.console.common.DisplayMessageConsoleException;
import net.grinder.console.common.Resources;
import net.grinder.util.Directory;

public final class ConsoleProperties {
    public static final String COLLECT_SAMPLES_PROPERTY = "grinder.console.numberToCollect";
    public static final String IGNORE_SAMPLES_PROPERTY = "grinder.console.numberToIgnore";
    public static final String SAMPLE_INTERVAL_PROPERTY = "grinder.console.sampleInterval";
    public static final String SIG_FIG_PROPERTY = "grinder.console.significantFigures";
    public static final String CONSOLE_HOST_PROPERTY = "grinder.console.consoleHost";
    public static final String CONSOLE_PORT_PROPERTY = "grinder.console.consolePort";
    public static final String HTTP_HOST_PROPERTY = "grinder.console.httpHost";
    public static final String HTTP_PORT_PROPERTY = "grinder.console.httpPort";
    public static final String RESET_CONSOLE_WITH_PROCESSES_PROPERTY = "grinder.console.resetConsoleWithProcesses";
    public static final String RESET_CONSOLE_WITH_PROCESSES_ASK_PROPERTY = "grinder.console.resetConsoleWithProcessesAsk";
    public static final String PROPERTIES_NOT_SET_ASK_PROPERTY = "grinder.console.propertiesNotSetAsk";
    public static final String START_WITH_UNSAVED_BUFFERS_ASK_PROPERTY = "grinder.console.startWithUnsavedBuffersAsk";
    public static final String STOP_PROCESSES_ASK_PROPERTY = "grinder.console.stopProcessesAsk";
    public static final String DISTRIBUTE_ON_START_ASK_PROPERTY = "grinder.console.distributeAutomaticallyAsk";
    public static final String PROPERTIES_FILE_PROPERTY = "grinder.console.propertiesFile";
    public static final String DISTRIBUTION_DIRECTORY_PROPERTY = "grinder.console.scriptDistributionDirectory";
    public static final String DISTRIBUTION_FILE_FILTER_EXPRESSION_PROPERTY = "grinder.console.distributionFileFilterExpression";
    public static final String DEFAULT_DISTRIBUTION_FILE_FILTER_EXPRESSION = "^CVS/$|^\\.svn/$|^.*~$|^(out_|error_|data_)\\w+-\\d+\\.log\\d*$";
    public static final String SCAN_DISTRIBUTION_FILES_PERIOD_PROPERTY = "grinder.console.scanDistributionFilesPeriod";
    public static final String LOOK_AND_FEEL_PROPERTY = "grinder.console.lookAndFeel";
    public static final String EXTERNAL_EDITOR_COMMAND_PROPERTY = "grinder.console.externalEditorCommand";
    public static final String EXTERNAL_EDITOR_ARGUMENTS_PROPERTY = "grinder.console.externalEditorArguments";
    public static final String FRAME_BOUNDS_PROPERTY = "grinder.console.frameBounds";
    public static final String SAVE_TOTALS_WITH_RESULTS_PROPERTY = "grinder.console.saveTotalsWithResults";
    private final PropertyChangeSupport m_changeSupport = new PropertyChangeSupport(this);
    private final IntProperty m_collectSampleCount = new IntProperty("grinder.console.numberToCollect", 0);
    private final IntProperty m_ignoreSampleCount = new IntProperty("grinder.console.numberToIgnore", 0);
    private final IntProperty m_sampleInterval = new IntProperty("grinder.console.sampleInterval", 1000);
    private final IntProperty m_significantFigures = new IntProperty("grinder.console.significantFigures", 3);
    private final BooleanProperty m_resetConsoleWithProcesses = new BooleanProperty("grinder.console.resetConsoleWithProcesses", false);
    private final FileProperty m_propertiesFile = new FileProperty("grinder.console.propertiesFile");
    private final DirectoryProperty m_distributionDirectory = new DirectoryProperty("grinder.console.scriptDistributionDirectory");
    private final PatternProperty m_distributionFileFilterPattern = new PatternProperty("grinder.console.distributionFileFilterExpression", "^CVS/$|^\\.svn/$|^.*~$|^(out_|error_|data_)\\w+-\\d+\\.log\\d*$");
    private final IntProperty m_scanDistributionFilesPeriod = new IntProperty("grinder.console.scanDistributionFilesPeriod", 6000);
    private final StringProperty m_lookAndFeel = new StringProperty("grinder.console.lookAndFeel", null);
    private final FileProperty m_externalEditorCommand = new FileProperty("grinder.console.externalEditorCommand");
    private final StringProperty m_externalEditorArguments = new StringProperty("grinder.console.externalEditorArguments", null);
    private final RectangleProperty m_frameBounds = new RectangleProperty("grinder.console.frameBounds");
    private final BooleanProperty m_resetConsoleWithProcessesAsk = new BooleanProperty("grinder.console.resetConsoleWithProcessesAsk", true);
    private final BooleanProperty m_propertiesNotSetAsk = new BooleanProperty("grinder.console.propertiesNotSetAsk", true);
    private final BooleanProperty m_startWithUnsavedBuffersAsk = new BooleanProperty("grinder.console.startWithUnsavedBuffersAsk", true);
    private final BooleanProperty m_stopProcessesAsk = new BooleanProperty("grinder.console.stopProcessesAsk", true);
    private final BooleanProperty m_distributeOnStartAsk = new BooleanProperty("grinder.console.distributeAutomaticallyAsk", true);
    private final StringProperty m_consoleHost = new StringProperty("grinder.console.consoleHost", "");
    private final IntProperty m_consolePort = new IntProperty("grinder.console.consolePort", 6372);
    private final StringProperty m_httpHost = new StringProperty("grinder.console.httpHost", "");
    private final IntProperty m_httpPort = new IntProperty("grinder.console.httpPort", 6373);
    private final BooleanProperty m_saveTotalsWithResults = new BooleanProperty("grinder.console.saveTotalsWithResults", false);
    private final Resources m_resources;
    private final GrinderProperties m_backingProperties;

    public ConsoleProperties(Resources resources, File file) throws ConsoleException {
        this.m_resources = resources;
        try {
            this.m_backingProperties = new GrinderProperties(file);
        }
        catch (GrinderProperties.PersistenceException e) {
            throw new DisplayMessageConsoleException(this.m_resources, "couldNotLoadOptionsError.text", e);
        }
    }

    public ConsoleProperties(ConsoleProperties properties) {
        this.m_resources = properties.m_resources;
        this.m_backingProperties = new GrinderProperties();
        this.m_backingProperties.setAssociatedFile(properties.m_backingProperties.getAssociatedFile());
        this.set(properties);
    }

    public void set(ConsoleProperties properties) {
        this.m_backingProperties.clear();
        this.m_backingProperties.putAll((Map<?, ?>)properties.m_backingProperties);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.m_changeSupport.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String property, PropertyChangeListener listener) {
        this.m_changeSupport.addPropertyChangeListener(property, listener);
    }

    public void save() throws ConsoleException {
        try {
            this.m_backingProperties.save();
        }
        catch (GrinderProperties.PersistenceException e) {
            throw new DisplayMessageConsoleException(this.m_resources, "couldNotSaveOptionsError.text", e);
        }
    }

    public int getCollectSampleCount() {
        return this.m_collectSampleCount.get();
    }

    public void setCollectSampleCount(int n) throws ConsoleException {
        if (n < 0) {
            throw new DisplayMessageConsoleException(this.m_resources, "collectNegativeError.text");
        }
        this.m_collectSampleCount.set(n);
    }

    public int getIgnoreSampleCount() {
        return this.m_ignoreSampleCount.get();
    }

    public void setIgnoreSampleCount(int n) throws ConsoleException {
        if (n < 0) {
            throw new DisplayMessageConsoleException(this.m_resources, "ignoreSamplesNegativeError.text");
        }
        this.m_ignoreSampleCount.set(n);
    }

    public int getSampleInterval() {
        return this.m_sampleInterval.get();
    }

    public void setSampleInterval(int interval) throws ConsoleException {
        if (interval <= 0) {
            throw new DisplayMessageConsoleException(this.m_resources, "intervalLessThanOneError.text");
        }
        this.m_sampleInterval.set(interval);
    }

    public int getSignificantFigures() {
        return this.m_significantFigures.get();
    }

    public void setSignificantFigures(int n) throws ConsoleException {
        if (n <= 0) {
            throw new DisplayMessageConsoleException(this.m_resources, "significantFiguresNegativeError.text");
        }
        this.m_significantFigures.set(n);
    }

    public String getConsoleHost() {
        return this.m_consoleHost.get();
    }

    private void checkAddress(String address) throws ConsoleException {
        if (address.length() > 0) {
            InetAddress newAddress;
            try {
                newAddress = InetAddress.getByName(address);
            }
            catch (UnknownHostException e) {
                throw new DisplayMessageConsoleException(this.m_resources, "unknownHostError.text");
            }
            if (newAddress.isMulticastAddress()) {
                throw new DisplayMessageConsoleException(this.m_resources, "invalidHostAddressError.text");
            }
        }
    }

    private void checkPort(int port) throws ConsoleException {
        if (port < 1 || port > 65535) {
            throw new DisplayMessageConsoleException(this.m_resources, "invalidPortNumberError.text", new Object[]{1, 65535});
        }
    }

    public void setConsoleHost(String s) throws ConsoleException {
        this.checkAddress(s);
        this.m_consoleHost.set(s);
    }

    public int getConsolePort() {
        return this.m_consolePort.get();
    }

    public void setConsolePort(int i) throws ConsoleException {
        this.checkPort(i);
        this.m_consolePort.set(i);
    }

    public String getHttpHost() {
        return this.m_httpHost.get();
    }

    public void setHttpHost(String s) throws ConsoleException {
        this.checkAddress(s);
        this.m_httpHost.set(s);
    }

    public int getHttpPort() {
        return this.m_httpPort.get();
    }

    public void setHttpPort(int i) throws ConsoleException {
        this.checkPort(i);
        this.m_httpPort.set(i);
    }

    public boolean getResetConsoleWithProcesses() {
        return this.m_resetConsoleWithProcesses.get();
    }

    public void setResetConsoleWithProcesses(boolean b) {
        this.m_resetConsoleWithProcesses.set(b);
    }

    public boolean getResetConsoleWithProcessesAsk() {
        return this.m_resetConsoleWithProcessesAsk.get();
    }

    public void setResetConsoleWithProcessesAsk(boolean value) throws ConsoleException {
        this.m_resetConsoleWithProcessesAsk.set(value);
        this.m_resetConsoleWithProcessesAsk.save();
    }

    public boolean getPropertiesNotSetAsk() {
        return this.m_propertiesNotSetAsk.get();
    }

    public void setPropertiesNotSetAsk(boolean value) throws ConsoleException {
        this.m_propertiesNotSetAsk.set(value);
        this.m_propertiesNotSetAsk.save();
    }

    public boolean getStartWithUnsavedBuffersAsk() {
        return this.m_startWithUnsavedBuffersAsk.get();
    }

    public void setStartWithUnsavedBuffersAsk(boolean value) throws ConsoleException {
        this.m_startWithUnsavedBuffersAsk.set(value);
        this.m_startWithUnsavedBuffersAsk.save();
    }

    public boolean getStopProcessesAsk() {
        return this.m_stopProcessesAsk.get();
    }

    public void setStopProcessesAsk(boolean value) throws ConsoleException {
        this.m_stopProcessesAsk.set(value);
        this.m_stopProcessesAsk.save();
    }

    public boolean getDistributeOnStartAsk() {
        return this.m_distributeOnStartAsk.get();
    }

    public void setDistributeOnStartAsk(boolean value) throws ConsoleException {
        this.m_distributeOnStartAsk.set(value);
        this.m_distributeOnStartAsk.save();
    }

    public File getPropertiesFile() {
        return this.m_propertiesFile.get();
    }

    public void setPropertiesFile(File propertiesFile) {
        this.m_propertiesFile.set(propertiesFile);
    }

    public void setAndSavePropertiesFile(File propertiesFile) throws ConsoleException {
        this.setPropertiesFile(propertiesFile);
        this.m_propertiesFile.save();
    }

    public Directory getDistributionDirectory() {
        return this.m_distributionDirectory.get();
    }

    public void setDistributionDirectory(Directory distributionDirectory) {
        this.m_distributionDirectory.set(distributionDirectory);
    }

    public void setAndSaveDistributionDirectory(Directory distributionDirectory) throws ConsoleException {
        this.setDistributionDirectory(distributionDirectory);
        this.m_distributionDirectory.save();
    }

    public Pattern getDistributionFileFilterPattern() {
        return this.m_distributionFileFilterPattern.get();
    }

    public String getDistributionFileFilterExpression() {
        return this.getDistributionFileFilterPattern().pattern();
    }

    public void setDistributionFileFilterExpression(String expression) throws ConsoleException {
        this.m_distributionFileFilterPattern.setExpression(expression);
    }

    public int getScanDistributionFilesPeriod() {
        return this.m_scanDistributionFilesPeriod.get();
    }

    public void setScanDistributionFilesPeriod(int i) throws ConsoleException {
        if (i < 0) {
            throw new DisplayMessageConsoleException(this.m_resources, "scanDistributionFilesPeriodNegativeError.text");
        }
        this.m_scanDistributionFilesPeriod.set(i);
    }

    public String getLookAndFeel() {
        return this.m_lookAndFeel.get();
    }

    public void setLookAndFeel(String lookAndFeel) {
        this.m_lookAndFeel.set(lookAndFeel);
    }

    public File getExternalEditorCommand() {
        return this.m_externalEditorCommand.get();
    }

    public void setExternalEditorCommand(File command) {
        this.m_externalEditorCommand.set(command);
    }

    public String getExternalEditorArguments() {
        return this.m_externalEditorArguments.get();
    }

    public void setExternalEditorArguments(String arguments) {
        this.m_externalEditorArguments.set(arguments);
    }

    public Rectangle getFrameBounds() {
        return this.m_frameBounds.get();
    }

    public void setFrameBounds(Rectangle bounds) {
        this.m_frameBounds.set(bounds);
    }

    public void setAndSaveFrameBounds(Rectangle bounds) throws ConsoleException {
        this.setFrameBounds(bounds);
        this.m_frameBounds.save();
    }

    public boolean getSaveTotalsWithResults() {
        return this.m_saveTotalsWithResults.get();
    }

    public void setSaveTotalsWithResults(boolean b) throws ConsoleException {
        this.m_saveTotalsWithResults.set(b);
        this.m_saveTotalsWithResults.save();
    }

    private final class RectangleProperty
    extends Property<Rectangle> {
        public RectangleProperty(String propertyName) {
            super(propertyName, null);
        }

        @Override
        public Rectangle get() {
            String property = ConsoleProperties.this.m_backingProperties.getProperty(this.getPropertyName(), null);
            if (property != null) {
                StringTokenizer tokenizer = new StringTokenizer(property, ",");
                try {
                    return new Rectangle(Integer.parseInt(tokenizer.nextToken()), Integer.parseInt(tokenizer.nextToken()), Integer.parseInt(tokenizer.nextToken()), Integer.parseInt(tokenizer.nextToken()));
                }
                catch (NoSuchElementException e) {
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return (Rectangle)this.getDefaultValue();
        }

        @Override
        public void setToStorage(Rectangle value) {
            ConsoleProperties.this.m_backingProperties.setProperty(this.getPropertyName(), value.x + "," + value.y + "," + value.width + "," + value.height);
        }
    }

    private final class BooleanProperty
    extends Property<Boolean> {
        public BooleanProperty(String propertyName, boolean defaultValue) {
            super(propertyName, defaultValue);
        }

        @Override
        protected Boolean get() {
            return ConsoleProperties.this.m_backingProperties.getBoolean(this.getPropertyName(), (Boolean)this.getDefaultValue());
        }

        @Override
        protected void setToStorage(Boolean value) {
            ConsoleProperties.this.m_backingProperties.setBoolean(this.getPropertyName(), value);
        }
    }

    private final class DirectoryProperty
    extends Property<Directory> {
        public DirectoryProperty(String propertyName) {
            super(propertyName, new Directory());
        }

        @Override
        protected Directory get() {
            File f = ConsoleProperties.this.m_backingProperties.getFile(this.getPropertyName(), null);
            if (f != null) {
                try {
                    return new Directory(f);
                }
                catch (Directory.DirectoryException directoryException) {
                    // empty catch block
                }
            }
            return new Directory();
        }

        @Override
        protected void setToStorage(Directory value) {
            ConsoleProperties.this.m_backingProperties.setFile(this.getPropertyName(), value.getFile());
        }
    }

    private final class FileProperty
    extends Property<File> {
        public FileProperty(String propertyName) {
            super(propertyName, null);
        }

        @Override
        protected File get() {
            return ConsoleProperties.this.m_backingProperties.getFile(this.getPropertyName(), (File)this.getDefaultValue());
        }

        @Override
        protected void setToStorage(File value) {
            ConsoleProperties.this.m_backingProperties.setFile(this.getPropertyName(), value);
        }
    }

    private final class IntProperty
    extends Property<Integer> {
        public IntProperty(String propertyName, int defaultValue) {
            super(propertyName, defaultValue);
        }

        @Override
        protected Integer get() {
            return ConsoleProperties.this.m_backingProperties.getInt(this.getPropertyName(), (Integer)this.getDefaultValue());
        }

        @Override
        protected void setToStorage(Integer value) {
            ConsoleProperties.this.m_backingProperties.setInt(this.getPropertyName(), value);
        }
    }

    private final class PatternProperty
    extends Property<Pattern> {
        public PatternProperty(String propertyName, String defaultExpression) {
            super(propertyName, Pattern.compile(defaultExpression));
        }

        @Override
        protected Pattern get() {
            String expression = ConsoleProperties.this.m_backingProperties.getProperty(this.getPropertyName());
            if (expression != null) {
                try {
                    return Pattern.compile(expression);
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    // empty catch block
                }
            }
            return (Pattern)this.getDefaultValue();
        }

        @Override
        protected void setToStorage(Pattern value) {
            ConsoleProperties.this.m_backingProperties.put(this.getPropertyName(), value.pattern());
        }

        public void setExpression(String expression) throws ConsoleException {
            if (expression == null) {
                ConsoleProperties.this.m_backingProperties.remove(this.getPropertyName());
            } else {
                try {
                    this.set(Pattern.compile(expression));
                }
                catch (PatternSyntaxException e) {
                    throw new DisplayMessageConsoleException(ConsoleProperties.this.m_resources, "regularExpressionError.text", new Object[]{this.getPropertyName()}, e);
                }
            }
        }
    }

    private final class StringProperty
    extends Property<String> {
        public StringProperty(String propertyName, String defaultValue) {
            super(propertyName, defaultValue);
        }

        @Override
        protected String get() {
            return ConsoleProperties.this.m_backingProperties.getProperty(this.getPropertyName(), (String)this.getDefaultValue());
        }

        @Override
        protected void setToStorage(String value) {
            ConsoleProperties.this.m_backingProperties.setProperty(this.getPropertyName(), value);
        }
    }

    private abstract class Property<T> {
        private final String m_propertyName;
        private final T m_defaultValue;

        Property(String propertyName, T defaultValue) {
            this.m_propertyName = propertyName;
            this.m_defaultValue = defaultValue;
        }

        public final void save() throws ConsoleException {
            try {
                ConsoleProperties.this.m_backingProperties.saveSingleProperty(this.m_propertyName);
            }
            catch (GrinderProperties.PersistenceException e) {
                throw new DisplayMessageConsoleException(ConsoleProperties.this.m_resources, "couldNotSaveOptionsError.text", e);
            }
        }

        protected final String getPropertyName() {
            return this.m_propertyName;
        }

        protected final T getDefaultValue() {
            return this.m_defaultValue;
        }

        protected abstract T get();

        protected abstract void setToStorage(T var1);

        public final void set(T value) {
            T old = this.get();
            T defaultValue = this.getDefaultValue();
            if (defaultValue == null && value == null || defaultValue != null && defaultValue.equals(value)) {
                ConsoleProperties.this.m_backingProperties.remove(this.m_propertyName);
            } else {
                this.setToStorage(value);
            }
            if (old == null && value == null) {
                return;
            }
            ConsoleProperties.this.m_changeSupport.firePropertyChange(this.getPropertyName(), old, value);
        }
    }
}

