/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.console.editor;

import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import net.grinder.console.common.DisplayMessageConsoleException;
import net.grinder.console.editor.BufferImplementation;
import net.grinder.console.editor.EditorException;
import net.grinder.console.editor.TextSource;

public interface Buffer {
    public TextSource getTextSource();

    public void load() throws DisplayMessageConsoleException, EditorException;

    public void save() throws DisplayMessageConsoleException, EditorException;

    public void save(File var1) throws DisplayMessageConsoleException;

    public boolean isDirty();

    public File getFile();

    public boolean isUpToDate();

    public Type getType();

    public String getDisplayName();

    public String toString();

    public void addListener(BufferImplementation.Listener var1);

    public static enum Type {
        JAVA_BUFFER("Java", "text/java", "java"),
        CLOJURE_BUFFER("Clojure", "text/clojure", "clj"),
        PYTHON_BUFFER("Python", "text/python", "py"),
        SHELL_BUFFER("Shell", "text/bash", "sh", "bash", "csh", "ksh"),
        HTML_BUFFER("HTML", "text/html", "html", "htm"),
        MSDOS_BATCH_BUFFER("MSDOS Batch", "text/dosbatch", "bat", "cmd"),
        XML_BUFFER("XML", "text/xml", "xml"),
        PROPERTIES_BUFFER("Unknown", "text/properties", "properties"),
        TEXT_BUFFER("Unknown", "text/text", "text", "txt");

        private final String m_name;
        private final String m_contentType;
        private Set<String> m_extensions;

        private Type(String name, String contentType, String ... extensions) {
            this.m_name = name;
            this.m_contentType = contentType;
            this.m_extensions = new HashSet<String>(Arrays.asList(extensions));
        }

        public String getName() {
            return this.m_name;
        }

        public String getContentType() {
            return this.m_contentType;
        }

        public static Type forExtension(String extension) {
            for (Type t : Type.values()) {
                if (!t.m_extensions.contains(extension)) continue;
                return t;
            }
            return TEXT_BUFFER;
        }
    }
}

