/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.console.distribution;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import net.grinder.communication.Address;
import net.grinder.console.communication.ProcessControl;
import net.grinder.console.distribution.AgentSet;
import net.grinder.console.distribution.CacheParameters;
import net.grinder.console.distribution.CacheParametersImplementation;
import net.grinder.console.distribution.UpdateableAgentCacheState;
import net.grinder.messages.agent.CacheHighWaterMark;
import net.grinder.messages.console.AgentAddress;
import net.grinder.messages.console.AgentAndCacheReport;
import net.grinder.util.Directory;

final class AgentCacheStateImplementation
implements UpdateableAgentCacheState {
    private final PropertyChangeSupport m_propertyChangeSupport = new PropertyChangeSupport(this);
    private CacheParameters m_cacheParameters;
    private long m_latestNewFileTime = -1L;
    private boolean m_outOfDate = false;
    private Set<AgentAndCacheReport> m_lastAgentReportSet = new HashSet<AgentAndCacheReport>();
    private long m_earliestAgentTime = -1L;

    public AgentCacheStateImplementation(ProcessControl processControl, Directory directory, Pattern fileFilterPattern) {
        this.reset(new CacheParametersImplementation(directory, fileFilterPattern));
        processControl.addProcessStatusListener(new ProcessReportListener());
    }

    private synchronized void reset(CacheParameters cacheParameters) {
        if (!cacheParameters.equals(this.m_cacheParameters)) {
            this.m_cacheParameters = cacheParameters;
            this.m_latestNewFileTime = -1L;
            this.m_lastAgentReportSet = new HashSet<AgentAndCacheReport>();
            this.m_earliestAgentTime = -1L;
        }
    }

    @Override
    public synchronized boolean getOutOfDate() {
        return this.m_outOfDate;
    }

    @Override
    public synchronized void setNewFileTime(long time) {
        this.m_latestNewFileTime = Math.max(this.m_latestNewFileTime, time);
    }

    @Override
    public void addListener(PropertyChangeListener listener) {
        this.m_propertyChangeSupport.addPropertyChangeListener(listener);
    }

    @Override
    public synchronized void setDirectory(Directory directory) {
        this.reset(new CacheParametersImplementation(directory, this.m_cacheParameters.getFileFilterPattern()));
    }

    @Override
    public synchronized void setFileFilterPattern(Pattern fileFilterPattern) {
        this.reset(new CacheParametersImplementation(this.m_cacheParameters.getDirectory(), fileFilterPattern));
    }

    @Override
    public synchronized CacheParameters getCacheParameters() {
        return this.m_cacheParameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized AgentSet getAgentSet() {
        AgentCacheStateImplementation agentCacheStateImplementation = this;
        synchronized (agentCacheStateImplementation) {
            return new AgentSetImplementation(this.getCacheParameters(), this.m_lastAgentReportSet, this.m_earliestAgentTime);
        }
    }

    private static final class AddressSet
    implements Address {
        private static final long serialVersionUID = 1L;
        private final Set<? extends Address> m_addresses;

        public AddressSet(Set<? extends Address> addresses) {
            this.m_addresses = addresses;
        }

        @Override
        public boolean includes(Address address) {
            return this.m_addresses.contains(address);
        }
    }

    private final class ProcessReportListener
    implements ProcessControl.Listener {
        private ProcessReportListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void update(ProcessControl.ProcessReports[] processReports) {
            boolean newOutOfDate;
            boolean oldOutOfDate;
            CacheHighWaterMark cacheState;
            HashSet<AgentAndCacheReport> agents = new HashSet<AgentAndCacheReport>();
            AgentCacheStateImplementation agentCacheStateImplementation = AgentCacheStateImplementation.this;
            synchronized (agentCacheStateImplementation) {
                cacheState = AgentCacheStateImplementation.this.m_cacheParameters.createHighWaterMark(AgentCacheStateImplementation.this.m_latestNewFileTime);
            }
            long earliestAgentTime = Long.MAX_VALUE;
            for (int i = 0; i < processReports.length; ++i) {
                AgentAndCacheReport agentReport = processReports[i].getAgentProcessReport();
                CacheHighWaterMark agentCache = agentReport.getCacheHighWaterMark();
                if (cacheState.isForSameCache(agentCache)) {
                    if (cacheState.getTime() > agentCache.getTime()) {
                        earliestAgentTime = Math.min(earliestAgentTime, agentCache.getTime());
                    }
                } else {
                    earliestAgentTime = -1L;
                }
                agents.add(agentReport);
            }
            AgentCacheStateImplementation agentCacheStateImplementation2 = AgentCacheStateImplementation.this;
            synchronized (agentCacheStateImplementation2) {
                AgentCacheStateImplementation.this.m_lastAgentReportSet = Collections.unmodifiableSet(agents);
                AgentCacheStateImplementation.this.m_earliestAgentTime = earliestAgentTime;
                oldOutOfDate = AgentCacheStateImplementation.this.m_outOfDate;
                newOutOfDate = earliestAgentTime < Long.MAX_VALUE;
                AgentCacheStateImplementation.this.m_outOfDate = newOutOfDate;
            }
            AgentCacheStateImplementation.this.m_propertyChangeSupport.firePropertyChange("outOfDate", oldOutOfDate, newOutOfDate);
        }
    }

    private final class AgentSetImplementation
    implements AgentSet {
        private final CacheParameters m_validCacheParameters;
        private final Set<AgentAndCacheReport> m_agentReports;
        private final long m_earliestAgentTime;

        private AgentSetImplementation(CacheParameters cacheParameters, Set<AgentAndCacheReport> agentReports, long earliestAgentTime) {
            this.m_validCacheParameters = cacheParameters;
            this.m_agentReports = agentReports;
            this.m_earliestAgentTime = earliestAgentTime;
        }

        private void checkValidity() throws AgentSet.OutOfDateException {
            if (!this.m_validCacheParameters.equals(AgentCacheStateImplementation.this.getCacheParameters())) {
                throw new AgentSet.OutOfDateException();
            }
        }

        @Override
        public Address getAddressOfAllAgents() throws AgentSet.OutOfDateException {
            this.checkValidity();
            HashSet<AgentAddress> agentAddresses = new HashSet<AgentAddress>();
            for (AgentAndCacheReport report : this.m_agentReports) {
                agentAddresses.add(new AgentAddress(report.getAgentIdentity()));
            }
            return new AddressSet(agentAddresses);
        }

        @Override
        public Address getAddressOfOutOfDateAgents(long time) throws AgentSet.OutOfDateException {
            this.checkValidity();
            CacheHighWaterMark cacheState = this.m_validCacheParameters.createHighWaterMark(time);
            HashSet<AgentAddress> outOfDateAgentAddresses = new HashSet<AgentAddress>();
            for (AgentAndCacheReport agentReport : this.m_agentReports) {
                CacheHighWaterMark agentCache = agentReport.getCacheHighWaterMark();
                if (cacheState.isForSameCache(agentCache)) {
                    if (cacheState.getTime() <= agentCache.getTime()) continue;
                    outOfDateAgentAddresses.add(new AgentAddress(agentReport.getAgentIdentity()));
                    continue;
                }
                outOfDateAgentAddresses.add(new AgentAddress(agentReport.getAgentIdentity()));
            }
            return new AddressSet(outOfDateAgentAddresses);
        }

        @Override
        public long getEarliestAgentTime() {
            return this.m_earliestAgentTime;
        }
    }
}

