/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.console.communication.server;

import net.grinder.communication.Message;
import net.grinder.communication.MessageDispatchRegistry;
import net.grinder.console.communication.ProcessControl;
import net.grinder.console.communication.server.messages.GetNumberOfAgentsMessage;
import net.grinder.console.communication.server.messages.ResetRecordingMessage;
import net.grinder.console.communication.server.messages.ResetWorkerProcessesMessage;
import net.grinder.console.communication.server.messages.ResultMessage;
import net.grinder.console.communication.server.messages.StartRecordingMessage;
import net.grinder.console.communication.server.messages.StartWorkerProcessesMessage;
import net.grinder.console.communication.server.messages.StopAgentAndWorkerProcessesMessage;
import net.grinder.console.communication.server.messages.StopRecordingMessage;
import net.grinder.console.communication.server.messages.SuccessMessage;
import net.grinder.console.model.SampleModel;
import net.grinder.console.model.SampleModelViews;

public class DispatchClientCommands {
    private final SampleModel m_model;
    private final SampleModelViews m_sampleModelViews;
    private final ProcessControl m_processControl;

    public DispatchClientCommands(SampleModel model, SampleModelViews sampleModelViews, ProcessControl processControl) {
        this.m_model = model;
        this.m_sampleModelViews = sampleModelViews;
        this.m_processControl = processControl;
    }

    public void registerMessageHandlers(MessageDispatchRegistry messageDispatcher) {
        messageDispatcher.set(StartRecordingMessage.class, new MessageDispatchRegistry.AbstractBlockingHandler<StartRecordingMessage>(){

            @Override
            public Message blockingSend(StartRecordingMessage message) {
                DispatchClientCommands.this.m_model.start();
                return new SuccessMessage();
            }
        });
        messageDispatcher.set(StopRecordingMessage.class, new MessageDispatchRegistry.AbstractBlockingHandler<StopRecordingMessage>(){

            @Override
            public Message blockingSend(StopRecordingMessage message) {
                DispatchClientCommands.this.m_model.stop();
                return new SuccessMessage();
            }
        });
        messageDispatcher.set(ResetRecordingMessage.class, new MessageDispatchRegistry.AbstractBlockingHandler<ResetRecordingMessage>(){

            @Override
            public Message blockingSend(ResetRecordingMessage message) {
                DispatchClientCommands.this.m_model.reset();
                DispatchClientCommands.this.m_sampleModelViews.resetStatisticsViews();
                return new SuccessMessage();
            }
        });
        messageDispatcher.set(GetNumberOfAgentsMessage.class, new MessageDispatchRegistry.AbstractBlockingHandler<GetNumberOfAgentsMessage>(){

            @Override
            public Message blockingSend(GetNumberOfAgentsMessage message) {
                return new ResultMessage(Integer.valueOf(DispatchClientCommands.this.m_processControl.getNumberOfLiveAgents()));
            }
        });
        messageDispatcher.set(StopAgentAndWorkerProcessesMessage.class, new MessageDispatchRegistry.AbstractBlockingHandler<StopAgentAndWorkerProcessesMessage>(){

            @Override
            public Message blockingSend(StopAgentAndWorkerProcessesMessage message) {
                DispatchClientCommands.this.m_processControl.stopAgentAndWorkerProcesses();
                return new SuccessMessage();
            }
        });
        messageDispatcher.set(StartWorkerProcessesMessage.class, new MessageDispatchRegistry.AbstractBlockingHandler<StartWorkerProcessesMessage>(){

            @Override
            public Message blockingSend(StartWorkerProcessesMessage message) {
                DispatchClientCommands.this.m_processControl.startWorkerProcesses(message.getProperties());
                return new SuccessMessage();
            }
        });
        messageDispatcher.set(ResetWorkerProcessesMessage.class, new MessageDispatchRegistry.AbstractBlockingHandler<ResetWorkerProcessesMessage>(){

            @Override
            public Message blockingSend(ResetWorkerProcessesMessage message) {
                DispatchClientCommands.this.m_processControl.resetWorkerProcesses();
                return new SuccessMessage();
            }
        });
    }
}

