/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.console.communication;

import java.util.Comparator;
import java.util.EventListener;
import net.grinder.common.GrinderProperties;
import net.grinder.common.processidentity.ProcessReport;
import net.grinder.common.processidentity.WorkerProcessReport;
import net.grinder.console.common.ConsoleException;
import net.grinder.messages.console.AgentAndCacheReport;
import net.grinder.util.Directory;

public interface ProcessControl {
    public void startWorkerProcesses(GrinderProperties var1);

    public void startWorkerProcessesWithDistributedFiles(Directory var1, GrinderProperties var2) throws ConsoleException;

    public void resetWorkerProcesses();

    public void stopAgentAndWorkerProcesses();

    public void addProcessStatusListener(Listener var1);

    public int getNumberOfLiveAgents();

    public static final class ProcessReportsComparator
    implements Comparator<ProcessReports> {
        private final Comparator<ProcessReport> m_processReportComparator = new ProcessReport.StateThenNameThenNumberComparator();

        @Override
        public int compare(ProcessReports o1, ProcessReports o2) {
            return this.m_processReportComparator.compare(o1.getAgentProcessReport(), o2.getAgentProcessReport());
        }
    }

    public static interface ProcessReports {
        public AgentAndCacheReport getAgentProcessReport();

        public WorkerProcessReport[] getWorkerProcessReports();
    }

    public static interface Listener
    extends EventListener {
        public void update(ProcessReports[] var1);
    }
}

