/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.console.communication;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.annotation.PreDestroy;
import net.grinder.communication.Acceptor;
import net.grinder.communication.Address;
import net.grinder.communication.CommunicationException;
import net.grinder.communication.ConnectionType;
import net.grinder.communication.FanOutServerSender;
import net.grinder.communication.Message;
import net.grinder.communication.MessageDispatchRegistry;
import net.grinder.communication.MessageDispatchSender;
import net.grinder.communication.ServerReceiver;
import net.grinder.console.common.DisplayMessageConsoleException;
import net.grinder.console.common.ErrorHandler;
import net.grinder.console.common.Resources;
import net.grinder.console.communication.ConsoleCommunication;
import net.grinder.console.model.ConsoleProperties;
import net.grinder.util.TimeAuthority;
import net.grinder.util.thread.BooleanCondition;

public final class ConsoleCommunicationImplementation
implements ConsoleCommunication {
    private final Resources m_resources;
    private final ConsoleProperties m_properties;
    private final ErrorHandler m_errorHandler;
    private final TimeAuthority m_timeAuthority;
    private final long m_idlePollDelay;
    private final long m_inactiveClientTimeOut;
    private final MessageDispatchSender m_messageDispatcher = new MessageDispatchSender();
    private final BooleanCondition m_processing = new BooleanCondition();
    private final BooleanCondition m_shutdown = new BooleanCondition();
    private Acceptor m_acceptor = null;
    private ServerReceiver m_receiver = null;
    private FanOutServerSender m_sender = null;

    public ConsoleCommunicationImplementation(Resources resources, ConsoleProperties properties, ErrorHandler errorHandler, TimeAuthority timeAuthority) throws DisplayMessageConsoleException {
        this(resources, properties, errorHandler, timeAuthority, 500L, 30000L);
    }

    public ConsoleCommunicationImplementation(Resources resources, ConsoleProperties properties, ErrorHandler errorHandler, TimeAuthority timeAuthority, long idlePollDelay, long inactiveClientTimeOut) throws DisplayMessageConsoleException {
        this.m_resources = resources;
        this.m_properties = properties;
        this.m_errorHandler = errorHandler;
        this.m_timeAuthority = timeAuthority;
        this.m_idlePollDelay = idlePollDelay;
        this.m_inactiveClientTimeOut = inactiveClientTimeOut;
        properties.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                String property = event.getPropertyName();
                if (property.equals("grinder.console.consoleHost") || property.equals("grinder.console.consolePort")) {
                    ConsoleCommunicationImplementation.this.reset();
                }
            }
        });
        this.reset();
    }

    private void reset() {
        try {
            if (this.m_acceptor != null) {
                this.m_acceptor.shutdown();
            }
        }
        catch (CommunicationException e) {
            this.m_errorHandler.handleException(e);
            return;
        }
        if (this.m_sender != null) {
            this.m_sender.shutdown();
        }
        if (this.m_receiver != null) {
            this.m_receiver.shutdown();
            this.m_processing.await(false);
        }
        if (this.m_shutdown.get()) {
            return;
        }
        try {
            this.m_acceptor = new Acceptor(this.m_properties.getConsoleHost(), this.m_properties.getConsolePort(), 1, this.m_timeAuthority);
        }
        catch (CommunicationException e) {
            this.m_errorHandler.handleException(new DisplayMessageConsoleException(this.m_resources, "localBindError.text", e));
            this.m_processing.wakeUpAllWaiters();
            return;
        }
        Thread acceptorProblemListener = new Thread("Acceptor problem listener"){

            @Override
            public void run() {
                Exception exception;
                while ((exception = ConsoleCommunicationImplementation.this.m_acceptor.getPendingException()) != null) {
                    ConsoleCommunicationImplementation.this.m_errorHandler.handleException(exception);
                }
            }
        };
        acceptorProblemListener.setDaemon(true);
        acceptorProblemListener.start();
        this.m_receiver = new ServerReceiver();
        try {
            this.m_receiver.receiveFrom(this.m_acceptor, new ConnectionType[]{ConnectionType.AGENT, ConnectionType.CONSOLE_CLIENT, ConnectionType.WORKER}, 5, this.m_idlePollDelay, this.m_inactiveClientTimeOut);
        }
        catch (CommunicationException e) {
            throw new AssertionError((Object)e);
        }
        try {
            this.m_sender = new FanOutServerSender(this.m_acceptor, ConnectionType.AGENT, 3);
        }
        catch (Acceptor.ShutdownException e) {
            this.m_processing.wakeUpAllWaiters();
            this.m_errorHandler.handleException(e);
            return;
        }
        this.m_processing.set(true);
    }

    @Override
    public MessageDispatchRegistry getMessageDispatchRegistry() {
        return this.m_messageDispatcher;
    }

    @Override
    @PreDestroy
    public void shutdown() {
        this.m_shutdown.set(true);
        this.m_processing.set(false);
        this.reset();
    }

    @Override
    public boolean processOneMessage() {
        while (!this.m_shutdown.get()) {
            if (!this.m_processing.await(true)) continue;
            try {
                Message message = this.m_receiver.waitForMessage();
                if (message == null) {
                    this.m_processing.set(false);
                    continue;
                }
                this.m_messageDispatcher.send(message);
                return true;
            }
            catch (CommunicationException e) {
                this.m_errorHandler.handleException(e);
                continue;
            }
            break;
        }
        return false;
    }

    public int getNumberOfConnections() {
        return this.m_acceptor == null ? 0 : this.m_acceptor.getNumberOfConnections();
    }

    @Override
    public void sendToAgents(Message message) {
        if (this.m_sender == null) {
            this.m_errorHandler.handleErrorMessage(this.m_resources.getString("sendError.text"));
        } else {
            try {
                this.m_sender.send(message);
            }
            catch (CommunicationException e) {
                this.m_errorHandler.handleException(new DisplayMessageConsoleException(this.m_resources, "sendError.text", e));
            }
        }
    }

    @Override
    public void sendToAddressedAgents(Address address, Message message) {
        if (this.m_sender == null) {
            this.m_errorHandler.handleErrorMessage(this.m_resources.getString("sendError.text"));
        } else {
            try {
                this.m_sender.send(address, message);
            }
            catch (CommunicationException e) {
                this.m_errorHandler.handleException(new DisplayMessageConsoleException(this.m_resources, "sendError.text", e));
            }
        }
    }
}

