/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.console.common;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import net.grinder.common.Closer;
import net.grinder.common.UncheckedInterruptedException;
import net.grinder.console.common.Resources;

public final class ResourcesImplementation
implements Resources {
    private PrintWriter m_errorWriter = new PrintWriter(System.err, true);
    private final ResourceBundle m_resources;
    private final String m_package;

    public ResourcesImplementation(String bundleName) {
        this.m_resources = ResourceBundle.getBundle(bundleName);
        int lastDot = bundleName.lastIndexOf(".");
        this.m_package = lastDot > 0 ? "/" + bundleName.substring(0, lastDot + 1).replace('.', '/') : "/";
    }

    public void setErrorWriter(PrintWriter writer) {
        this.m_errorWriter = writer;
    }

    @Override
    public String getString(String key) {
        return this.getString(key, true);
    }

    @Override
    public String getString(String key, boolean warnIfMissing) {
        try {
            return this.m_resources.getString(key);
        }
        catch (MissingResourceException e) {
            if (warnIfMissing) {
                this.m_errorWriter.println("Warning - resource " + key + " not specified");
                return "";
            }
            return null;
        }
    }

    @Override
    public ImageIcon getImageIcon(String key) {
        return this.getImageIcon(key, false);
    }

    @Override
    public ImageIcon getImageIcon(String key, boolean warnIfMissing) {
        URL resource = this.get(key, warnIfMissing);
        return resource != null ? new ImageIcon(resource) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getStringFromFile(String key, boolean warnIfMissing) {
        URL resource = this.get(key, warnIfMissing);
        if (resource != null) {
            String string;
            InputStreamReader in = null;
            try {
                int n;
                in = new InputStreamReader(resource.openStream());
                StringWriter out = new StringWriter();
                char[] buffer = new char[128];
                while ((n = in.read(buffer)) != -1) {
                    out.write(buffer, 0, n);
                }
                out.close();
                string = out.toString();
            }
            catch (IOException e) {
                try {
                    UncheckedInterruptedException.ioException(e);
                    this.m_errorWriter.println("Warning - could not read " + resource);
                }
                catch (Throwable throwable) {
                    Closer.close(in);
                    throw throwable;
                }
                Closer.close(in);
            }
            Closer.close(in);
            return string;
        }
        return null;
    }

    private URL get(String key, boolean warnIfMissing) {
        String name = this.getString(key, warnIfMissing);
        if (name == null || name.length() == 0) {
            return null;
        }
        URL url = this.getClass().getResource(this.m_package + name);
        if (url == null) {
            this.m_errorWriter.println("Warning - could not load resource " + name);
        }
        return url;
    }
}

