/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.console.common;

import net.grinder.common.processidentity.AgentIdentity;
import net.grinder.common.processidentity.AgentProcessReport;
import net.grinder.common.processidentity.WorkerProcessReport;
import net.grinder.console.common.Resources;

public final class ProcessReportDescriptionFactory {
    private final String m_threadsString;
    private final String m_agentString;
    private final String m_workerString;
    private final String m_stateStartedString;
    private final String m_stateRunningString;
    private final String m_stateFinishedString;
    private final String m_stateConnectedString;
    private final String m_stateDisconnectedString;
    private final String m_stateUnknownString;

    public ProcessReportDescriptionFactory(Resources resources) {
        this.m_threadsString = resources.getString("processTable.threads.label");
        this.m_agentString = resources.getString("processTable.agentProcess.label");
        this.m_workerString = resources.getString("processTable.workerProcess.label");
        this.m_stateStartedString = resources.getString("processState.started.label");
        this.m_stateRunningString = resources.getString("processState.running.label");
        this.m_stateFinishedString = resources.getString("processState.finished.label");
        this.m_stateConnectedString = resources.getString("processState.connected.label");
        this.m_stateDisconnectedString = resources.getString("processState.disconnected.label");
        this.m_stateUnknownString = resources.getString("processState.unknown.label");
    }

    public ProcessDescription create(AgentProcessReport agentProcessReport) {
        String state;
        switch (agentProcessReport.getState()) {
            case STARTED: 
            case RUNNING: {
                state = this.m_stateConnectedString;
                break;
            }
            case FINISHED: {
                state = this.m_stateDisconnectedString;
                break;
            }
            default: {
                state = this.m_stateUnknownString;
            }
        }
        AgentIdentity agentIdentity = agentProcessReport.getAgentIdentity();
        StringBuilder name = new StringBuilder(agentIdentity.getName());
        if (agentIdentity.getNumber() >= 0) {
            name.append(" (");
            name.append(this.m_agentString);
            name.append(" ");
            name.append(agentIdentity.getNumber());
            name.append(")");
        }
        return new ProcessDescription(name.toString(), this.m_agentString, state);
    }

    public ProcessDescription create(WorkerProcessReport workerProcessReport) {
        String state;
        switch (workerProcessReport.getState()) {
            case STARTED: {
                state = this.m_stateStartedString;
                break;
            }
            case RUNNING: {
                state = this.m_stateRunningString + " (" + workerProcessReport.getNumberOfRunningThreads() + "/" + workerProcessReport.getMaximumNumberOfThreads() + " " + this.m_threadsString + ")";
                break;
            }
            case FINISHED: {
                state = this.m_stateFinishedString;
                break;
            }
            default: {
                state = this.m_stateUnknownString;
            }
        }
        return new ProcessDescription(workerProcessReport.getWorkerIdentity().getName(), this.m_workerString, state);
    }

    public static final class ProcessDescription {
        private final String m_name;
        private final String m_processType;
        private final String m_state;

        private ProcessDescription(String name, String processType, String state) {
            this.m_name = name;
            this.m_processType = processType;
            this.m_state = state;
        }

        public String getName() {
            return this.m_name;
        }

        public String getProcessType() {
            return this.m_processType;
        }

        public String getState() {
            return this.m_state;
        }

        public String toString() {
            return this.getProcessType() + " " + this.getName() + " [" + this.getState() + "]";
        }
    }
}

