/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.console.client;

import net.grinder.common.GrinderProperties;
import net.grinder.communication.BlockingSender;
import net.grinder.communication.CommunicationException;
import net.grinder.communication.Message;
import net.grinder.console.client.ConsoleConnection;
import net.grinder.console.client.ConsoleConnectionException;
import net.grinder.console.communication.server.messages.GetNumberOfAgentsMessage;
import net.grinder.console.communication.server.messages.ResetRecordingMessage;
import net.grinder.console.communication.server.messages.ResetWorkerProcessesMessage;
import net.grinder.console.communication.server.messages.ResultMessage;
import net.grinder.console.communication.server.messages.StartRecordingMessage;
import net.grinder.console.communication.server.messages.StartWorkerProcessesMessage;
import net.grinder.console.communication.server.messages.StopAgentAndWorkerProcessesMessage;
import net.grinder.console.communication.server.messages.StopRecordingMessage;

final class ConsoleConnectionImplementation
implements ConsoleConnection {
    private final BlockingSender m_consoleSender;

    ConsoleConnectionImplementation(BlockingSender consoleSender) {
        this.m_consoleSender = consoleSender;
    }

    @Override
    public void close() {
        this.m_consoleSender.shutdown();
    }

    @Override
    public void startRecording() throws ConsoleConnectionException {
        try {
            this.m_consoleSender.blockingSend(new StartRecordingMessage());
        }
        catch (CommunicationException e) {
            throw new ConsoleConnectionException("Failed to start recording", e);
        }
    }

    @Override
    public void stopRecording() throws ConsoleConnectionException {
        try {
            this.m_consoleSender.blockingSend(new StopRecordingMessage());
        }
        catch (CommunicationException e) {
            throw new ConsoleConnectionException("Failed to stop recording", e);
        }
    }

    @Override
    public void resetRecording() throws ConsoleConnectionException {
        try {
            this.m_consoleSender.blockingSend(new ResetRecordingMessage());
        }
        catch (CommunicationException e) {
            throw new ConsoleConnectionException("Failed to reset recording", e);
        }
    }

    @Override
    public int getNumberOfAgents() throws ConsoleConnectionException {
        Object result;
        Message response;
        try {
            response = this.m_consoleSender.blockingSend(new GetNumberOfAgentsMessage());
        }
        catch (CommunicationException e) {
            throw new ConsoleConnectionException("getNumberOfLiveAgents()", e);
        }
        if (response instanceof ResultMessage && (result = ((ResultMessage)response).getResult()) instanceof Integer) {
            return (Integer)result;
        }
        throw new ConsoleConnectionException("Unexpected response: " + response);
    }

    @Override
    public void stopAgents() throws ConsoleConnectionException {
        try {
            this.m_consoleSender.blockingSend(new StopAgentAndWorkerProcessesMessage());
        }
        catch (CommunicationException e) {
            throw new ConsoleConnectionException("Failed to stop agent processes", e);
        }
    }

    @Override
    public void startWorkerProcesses(GrinderProperties properties) throws ConsoleConnectionException {
        try {
            this.m_consoleSender.blockingSend(new StartWorkerProcessesMessage(properties));
        }
        catch (CommunicationException e) {
            throw new ConsoleConnectionException("Failed to start worker processes", e);
        }
    }

    @Override
    public void resetWorkerProcesses() throws ConsoleConnectionException {
        try {
            this.m_consoleSender.blockingSend(new ResetWorkerProcessesMessage());
        }
        catch (CommunicationException e) {
            throw new ConsoleConnectionException("Failed to reset worker processes", e);
        }
    }
}

