/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.communication;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import net.grinder.common.Closer;
import net.grinder.communication.Address;
import net.grinder.communication.CommunicationException;
import net.grinder.communication.ConnectionIdentity;
import net.grinder.communication.ResourcePool;
import net.grinder.communication.StreamSender;
import net.grinder.util.ListenerSupport;

class SocketWrapper
implements ResourcePool.Resource {
    private final Socket m_socket;
    private final ConnectionIdentity m_connectionIdentity;
    private final InputStream m_inputStream;
    private final OutputStream m_outputStream;
    private final ListenerSupport<ClosedListener> m_closedListeners = new ListenerSupport();
    private final ListenerSupport.Informer<ClosedListener> m_closedInformer = new ListenerSupport.Informer<ClosedListener>(){

        @Override
        public void inform(ClosedListener l) {
            l.socketClosed();
        }
    };
    private Address m_address;

    public SocketWrapper(Socket socket) throws CommunicationException {
        this.m_socket = socket;
        try {
            this.m_inputStream = this.m_socket.getInputStream();
            this.m_outputStream = this.m_socket.getOutputStream();
            this.m_connectionIdentity = new ConnectionIdentity(this.m_socket.getInetAddress(), this.m_socket.getPort(), System.currentTimeMillis());
        }
        catch (IOException e) {
            Closer.close(this.m_socket);
            throw new CommunicationException("Could not establish communication", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (!this.m_socket.isClosed()) {
            OutputStream outputStream = this.m_outputStream;
            synchronized (outputStream) {
                new StreamSender(this.m_outputStream).shutdown();
            }
            Closer.close(this.m_socket);
            this.m_closedListeners.apply(this.m_closedInformer);
        }
    }

    public boolean isClosed() {
        return this.m_socket.isClosed();
    }

    public ConnectionIdentity getConnectionIdentity() {
        return this.m_connectionIdentity;
    }

    public InputStream getInputStream() {
        return this.m_inputStream;
    }

    public OutputStream getOutputStream() {
        return this.m_outputStream;
    }

    public void addClosedListener(ClosedListener listener) {
        this.m_closedListeners.add(listener);
    }

    public void setAddress(Address address) {
        this.m_address = address;
    }

    public Address getAddress() {
        return this.m_address;
    }

    public static interface ClosedListener {
        public void socketClosed();
    }
}

