/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.communication;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.concurrent.ExecutorService;
import net.grinder.common.UncheckedInterruptedException;
import net.grinder.communication.Acceptor;
import net.grinder.communication.AddressAwareMessage;
import net.grinder.communication.CloseCommunicationMessage;
import net.grinder.communication.CommunicationException;
import net.grinder.communication.ConnectionType;
import net.grinder.communication.IdleAwareSocketWrapper;
import net.grinder.communication.Message;
import net.grinder.communication.MessageQueue;
import net.grinder.communication.MessageRequiringResponse;
import net.grinder.communication.Receiver;
import net.grinder.communication.ResourcePool;
import net.grinder.communication.Sender;
import net.grinder.communication.StreamSender;
import net.grinder.util.thread.ExecutorFactory;
import net.grinder.util.thread.InterruptibleRunnable;
import net.grinder.util.thread.InterruptibleRunnableAdapter;

public final class ServerReceiver
implements Receiver {
    private final MessageQueue m_messageQueue = new MessageQueue(true);
    private final ExecutorService m_executor = ExecutorFactory.createCachedThreadPool("ServerReceiver");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveFrom(Acceptor acceptor, ConnectionType[] connectionTypes, int numberOfThreads, long idleThreadPollDelay, long inactiveClientTimeOut) throws CommunicationException {
        if (connectionTypes.length == 0) {
            return;
        }
        ResourcePool[] acceptedSocketSets = new ResourcePool[connectionTypes.length];
        for (int i = 0; i < connectionTypes.length; ++i) {
            acceptedSocketSets[i] = acceptor.getSocketSet(connectionTypes[i]);
        }
        ServerReceiver serverReceiver = this;
        synchronized (serverReceiver) {
            this.m_messageQueue.checkIfShutdown();
            for (int i = 0; i < numberOfThreads; ++i) {
                this.m_executor.submit(new InterruptibleRunnableAdapter(new ServerReceiverRunnable(new CombinedResourcePool(acceptedSocketSets), idleThreadPollDelay, inactiveClientTimeOut)));
            }
        }
    }

    @Override
    public Message waitForMessage() throws CommunicationException {
        try {
            return this.m_messageQueue.dequeue(true);
        }
        catch (MessageQueue.ShutdownException e) {
            return null;
        }
    }

    @Override
    public synchronized void shutdown() {
        this.m_messageQueue.shutdown();
        this.m_executor.shutdownNow();
    }

    static /* synthetic */ MessageQueue access$200(ServerReceiver x0) {
        return x0.m_messageQueue;
    }

    private static final class SenderWithReservation
    implements Sender {
        private final Sender m_delegateSender;
        private final ResourcePool.Reservation m_reservation;

        private SenderWithReservation(Sender delegateSender, ResourcePool.Reservation reservation) {
            this.m_delegateSender = delegateSender;
            this.m_reservation = reservation;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void send(Message message) throws CommunicationException {
            try {
                this.m_delegateSender.send(message);
            }
            finally {
                this.shutdown();
            }
        }

        @Override
        public void shutdown() {
            this.m_reservation.free();
        }
    }

    private final class ServerReceiverRunnable
    implements InterruptibleRunnable {
        private final CombinedResourcePool m_sockets;
        private final long m_delay;
        private final long m_inactiveClientTimeOut;

        private ServerReceiverRunnable(CombinedResourcePool sockets, long delay, long inactiveClientTimeOut) {
            this.m_sockets = sockets;
            this.m_delay = delay;
            this.m_inactiveClientTimeOut = inactiveClientTimeOut;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void interruptibleRun() {
            try {
                try {
                    idle = false;
                    while (true) lbl-1000:
                    // 10 sources

                    {
                        reservation = this.m_sockets.reserveNext();
                        holdReservation = false;
                        try {
                            if (reservation.isSentinel()) {
                                if (idle) {
                                    Thread.sleep(this.m_delay);
                                }
                                idle = true;
                            }
                            socketWrapper = (IdleAwareSocketWrapper)reservation.getResource();
                            if (!socketWrapper.hasData(this.m_inactiveClientTimeOut)) ** GOTO lbl-1000
                            idle = false;
                            objectStream = new ObjectInputStream(socketWrapper.getInputStream());
                            message = (Message)objectStream.readObject();
                            if (message instanceof CloseCommunicationMessage) {
                                reservation.close();
                            }
                            if (message instanceof AddressAwareMessage) {
                                addressAware = (AddressAwareMessage)message;
                                addressAware.setAddress(socketWrapper.getAddress());
                            }
                            if (message instanceof MessageRequiringResponse) {
                                messageRequiringResponse = (MessageRequiringResponse)message;
                                messageRequiringResponse.setResponder(new SenderWithReservation(new StreamSender(socketWrapper.getOutputStream()), reservation));
                                ServerReceiver.access$200(ServerReceiver.this).queue(message);
                                holdReservation = true;
                            }
                            ServerReceiver.access$200(ServerReceiver.this).queue(message);
                        }
                        catch (CommunicationException e) {
                            reservation.close();
                            ServerReceiver.access$200(ServerReceiver.this).queue(e);
                        }
                        catch (IOException e) {
                            reservation.close();
                            UncheckedInterruptedException.ioException(e);
                            ServerReceiver.access$200(ServerReceiver.this).queue(e);
                        }
                        catch (ClassNotFoundException e) {
                            reservation.close();
                            ServerReceiver.access$200(ServerReceiver.this).queue(e);
                        }
                        catch (InterruptedException e) {
                            reservation.close();
                            throw new UncheckedInterruptedException(e);
                        }
                        finally {
                            if (holdReservation) continue;
                            reservation.free();
                            continue;
                        }
                        break;
                    }
                }
                catch (MessageQueue.ShutdownException var1_2) {
                    ServerReceiver.this.shutdown();
                }
                ** GOTO lbl-1000
            }
            catch (Throwable var9_14) {
                ServerReceiver.this.shutdown();
                throw var9_14;
            }
        }
    }

    private static final class CombinedResourcePool {
        private final ResourcePool[] m_resourcePools;
        private int m_next;

        CombinedResourcePool(ResourcePool[] resourcePools) {
            assert (resourcePools.length > 0);
            this.m_resourcePools = resourcePools;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ResourcePool.Reservation reserveNext() {
            int i = 0;
            ResourcePool[] resourcePoolArray = this.m_resourcePools;
            synchronized (this.m_resourcePools) {
                int start = ++this.m_next;
                // ** MonitorExit[var3_2] (shouldn't be in output)
                ResourcePool.Reservation reservation;
                while ((reservation = this.m_resourcePools[(start + i) % this.m_resourcePools.length].reserveNext()).isSentinel() && i != this.m_resourcePools.length - 1) {
                    ++i;
                }
                return reservation;
            }
        }
    }
}

